/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.simpledb;

import java.util.Map;
import org.refcodes.logger.Logger;
import org.refcodes.logger.LoggerFactory;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.tabular.ColumnFactory;
import org.refcodes.textual.SecretHintBuilder;

abstract class AbstractSimpleDbLoggerFactory<L extends Logger<T>, T>
implements LoggerFactory<L> {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private String _schemaPrefix;
    private String _accessKey;
    private String _secretKey;
    private String _endPoint;
    private ColumnFactory<T> _columnFactory;

    public AbstractSimpleDbLoggerFactory(String string, String string2, String string3, String string4, ColumnFactory<T> columnFactory) {
        this._schemaPrefix = string;
        this._accessKey = string2;
        this._secretKey = string3;
        this._endPoint = string4;
        this._columnFactory = columnFactory;
        LOGGER.debug("Using Amazon SimpleDB domain prefix \"" + string + "\", access key \"" + SecretHintBuilder.asString((String)string2) + "\", secret key \"" + SecretHintBuilder.asString((String)string3) + "\" and the end-point \"" + string4 + "\".");
    }

    public abstract L createInstance(String var1);

    public L createInstance(String string, Map<String, String> map) {
        return this.createInstance(string);
    }

    protected String getSchemaPrefix() {
        return this._schemaPrefix;
    }

    protected String getAccessKey() {
        return this._accessKey;
    }

    protected String getSecretKey() {
        return this._secretKey;
    }

    protected String getEndPoint() {
        return this._endPoint;
    }

    protected ColumnFactory<T> getColumnFactory() {
        return this._columnFactory;
    }
}

