/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.simpledb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.NoSuchDomainException;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.refcodes.component.Component;
import org.refcodes.component.Decomposeable;
import org.refcodes.component.Flushable;
import org.refcodes.component.Initializable;
import org.refcodes.component.InitializeException;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.LatencySleepTime;
import org.refcodes.data.LoopExtensionTime;
import org.refcodes.data.ScheduleSleepTime;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.generator.UniqueIdGeneratorSingleton;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.Logger;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerSingleton;
import org.refcodes.logger.UnexpectedLogRuntimeException;
import org.refcodes.logger.alt.simpledb.AbstractSimpleDbClient;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnFactory;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.HeaderImpl;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.Record;

public class SimpleDbLogger<T>
extends AbstractSimpleDbClient
implements Logger<T>,
Component,
Initializable,
Decomposeable,
Flushable {
    protected static RuntimeLogger LOGGER = RuntimeLoggerSingleton.getInstance();
    private static final int BUFFER_WRITE_SIZE = 23;
    private static final int FIELD_MAX_SIZE = 1024;
    private String _baseItemName = UniqueIdGeneratorSingleton.getInstance().next();
    private int _itemNameCounter = 0;
    private List<ReplaceableItem> _replaceableItemBuffer = new ArrayList<ReplaceableItem>();
    private Timer _bufferTimer;
    private ColumnFactory<T> _columnFactory;
    private Header<T> _header = new HeaderImpl();

    public SimpleDbLogger(String string, String string2, String string3, ColumnFactory<T> columnFactory) {
        this(string, string2, string3, null, columnFactory);
    }

    public SimpleDbLogger(String string, String string2, String string3, String string4, ColumnFactory<T> columnFactory) {
        super(string, string2, string3);
        this._bufferTimer = new Timer(true);
        this._bufferTimer.schedule((TimerTask)new BufferDaemon(), ScheduleSleepTime.NORM_SCHEDULE_SLEEP_TIME_IN_MS.getTimeInMs(), (long)ScheduleSleepTime.NORM_SCHEDULE_SLEEP_TIME_IN_MS.getTimeInMs());
        this._columnFactory = columnFactory;
    }

    public void log(Record<? extends T> record) throws IllegalRecordRuntimeException, UnexpectedLogRuntimeException {
        if ((record = record.toPurged()).isEmpty()) {
            LOGGER.info("Ignoring record \"" + record.toString() + "\" to be logged for Amazon SimpleDB domain \"" + this.getAmazonSimpleDbDomainName() + "\" as it is empty.");
        } else {
            Record record2;
            LOGGER.info("Logging record \"" + record.toString() + "\" for Amazon SimpleDB domain \"" + this.getAmazonSimpleDbDomainName() + "\".");
            ReplaceableItem replaceableItem = new ReplaceableItem(this.nextItemName());
            ArrayList<ReplaceableAttribute> arrayList = new ArrayList<ReplaceableAttribute>();
            for (Object object : record.keySet()) {
                this.addHeaderColumn((String)object);
            }
            if (LOGGER.isLogDebug()) {
                LOGGER.debug("Processed incoming record to be: \"" + record.toString() + "\"");
            }
            try {
                record2 = this._header.toStorageString(record);
            }
            catch (ColumnMismatchException | HeaderMismatchException throwable) {
                throw new IllegalRecordRuntimeException(record, ExceptionUtility.toMessage((Throwable)throwable), throwable);
            }
            if (LOGGER.isLogDebug()) {
                LOGGER.debug("String processed record to be: \"" + record2.toString() + "\"");
            }
            for (String string : record2.keySet()) {
                String string2;
                Object object;
                this.addHeaderColumn(string);
                object = record2.get((Object)string);
                if (object == null) continue;
                if (object.getClass().isArray()) {
                    Object[] objectArray = (Object[])object;
                    for (int i = 0; i < objectArray.length; ++i) {
                        string2 = objectArray[i].toString();
                        if ((string2 = this.toTruncatedField(string, string2)).length() == 0) continue;
                        arrayList.add(new ReplaceableAttribute(string, string2, Boolean.valueOf(false)));
                    }
                    continue;
                }
                string2 = this.toTruncatedField(string, object.toString());
                if (string2.length() == 0) continue;
                arrayList.add(new ReplaceableAttribute(string, string2, Boolean.valueOf(false)));
            }
            this.writeBuffer(replaceableItem.withAttributes(arrayList));
        }
    }

    public void initialize() throws InitializeException {
        LOGGER.info("Initializing component \"" + this.getClass().getName() + "\" for domain \"" + this.getAmazonSimpleDbDomainName() + "\".");
        try {
            DomainMetadataRequest domainMetadataRequest = new DomainMetadataRequest(this.getAmazonSimpleDbDomainName());
            this.getAmazonSimpleDbClient().domainMetadata(domainMetadataRequest);
        }
        catch (NoSuchDomainException noSuchDomainException) {
            LOGGER.info("Creating non existing domain \"" + this.getAmazonSimpleDbDomainName() + "\"...");
            CreateDomainRequest createDomainRequest = new CreateDomainRequest(this.getAmazonSimpleDbDomainName());
            this.getAmazonSimpleDbClient().createDomain(createDomainRequest);
        }
    }

    public synchronized void destroy() {
        LOGGER.info("Destroying component \"" + this.getClass().getName() + "\" for domain \"" + this.getAmazonSimpleDbDomainName() + "\".");
        this.flushBuffer();
        if (this._bufferTimer != null) {
            this._bufferTimer.cancel();
            this._bufferTimer = null;
        }
    }

    public void decompose() {
        LOGGER.info("Decomposing (deleting) \"" + this.getClass().getName() + "\" component for domain \"" + this.getAmazonSimpleDbDomainName() + "\"...");
        this.getAmazonSimpleDbClient().deleteDomain(new DeleteDomainRequest(this.getAmazonSimpleDbDomainName()));
    }

    public void flush() throws IOException {
        LOGGER.info("Flushing \"" + this.getClass().getName() + "\" component for domain \"" + this.getAmazonSimpleDbDomainName() + "\"...");
        this.flushBuffer();
    }

    protected Header<T> getHeader() {
        return this._header;
    }

    protected void addHeaderColumn(String string) {
        if (!this._header.containsKey((Object)string)) {
            try {
                Column column = this._columnFactory.createInstance(string);
                this._header.add((Object)column);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.warn("Race condition detected? " + ExceptionUtility.toMessage((Throwable)illegalArgumentException), (Throwable)illegalArgumentException);
            }
        }
    }

    private String toTruncatedField(String string, String string2) {
        if (string2.length() >= 1024) {
            LOGGER.warn("The field with key \"" + string + "\" ecceeds the max. allowed size of <1024> characters by <\"" + (string2.length() - 1024) + "\"> characters. Concatenating the value \"" + string2 + "\" to the first <1024> characters! Data loss might occur!");
            string2 = string2.substring(0, 1024);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextItemName() {
        SimpleDbLogger simpleDbLogger = this;
        synchronized (simpleDbLogger) {
            if (this._itemNameCounter == Integer.MAX_VALUE) {
                UniqueIdGeneratorSingleton.getInstance().next();
                this._itemNameCounter = 0;
            }
        }
        return this._baseItemName + "-" + this._itemNameCounter++;
    }

    protected synchronized void flushBuffer() {
        if (this._replaceableItemBuffer.size() > 0) {
            ArrayList<ReplaceableItem> arrayList = new ArrayList<ReplaceableItem>();
            while (this._replaceableItemBuffer.size() > 0 || arrayList.size() > 0) {
                int n = this._replaceableItemBuffer.size();
                while (this._replaceableItemBuffer.size() > 0 && arrayList.size() < 23) {
                    arrayList.add(this._replaceableItemBuffer.remove(0));
                }
                if (arrayList.size() <= 0) continue;
                if (LOGGER.isLogDebug()) {
                    LOGGER.debug("Found <" + n + "> lines in the buffer, flushing frame of <" + arrayList.size() + "> lines in this iteration of the buffer for domain \"" + this.getAmazonSimpleDbDomainName() + "\".");
                }
                BatchPutAttributesRequest batchPutAttributesRequest = new BatchPutAttributesRequest(this.getAmazonSimpleDbDomainName(), arrayList);
                AmazonClientException amazonClientException = null;
                boolean bl = false;
                RetryCounter retryCounter = new RetryCounter(IoRetryCount.NORM.getValue().intValue(), (long)LatencySleepTime.NORM.getTimeInMs(), (long)LoopExtensionTime.NORM.getTimeInMs());
                while (retryCounter.nextRetry()) {
                    try {
                        this.getAmazonSimpleDbClient().batchPutAttributes(batchPutAttributesRequest);
                        break;
                    }
                    catch (AmazonClientException amazonClientException2) {
                        if (amazonClientException != null && !((Object)((Object)amazonClientException2)).getClass().equals(((Object)((Object)amazonClientException)).getClass())) {
                            bl = true;
                        }
                        amazonClientException = amazonClientException2;
                        String string = "Failed flushing <" + arrayList.size() + "> lines of <" + n + "> from the log buffer to Amazon SimpleDB. Retrying in <" + retryCounter.getNextRetryDelayInMs() / 1000L + "> seconds ...";
                        string = string + SimpleDbLogger.toMessage(amazonClientException2);
                        LOGGER.warn(string);
                        if (retryCounter.hasNextRetry()) continue;
                        String string2 = "Failed flushing <" + arrayList.size() + "> lines of <" + n + "> from log buffer to Amazon SimpleDB db. Retried <" + retryCounter.getRetryNumber() + "> times.";
                        string2 = string2 + " The last error message was: " + SimpleDbLogger.toMessage(amazonClientException);
                        LOGGER.error(string2, (Throwable)amazonClientException);
                    }
                }
                if (amazonClientException != null && (SimpleDbLogger.isRequestTimeoutException(amazonClientException) || SimpleDbLogger.isServiceUnavailableException((Exception)((Object)amazonClientException))) && !bl) continue;
                arrayList.clear();
            }
        }
    }

    private synchronized void writeBuffer(ReplaceableItem replaceableItem) {
        this._replaceableItemBuffer.add(replaceableItem);
        if (this._replaceableItemBuffer.size() >= 23) {
            this.flushBuffer();
        }
    }

    private class BufferDaemon
    extends TimerTask {
        private BufferDaemon() {
        }

        @Override
        public void run() {
            SimpleDbLogger.this.flushBuffer();
        }
    }
}

