/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.simpledb;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.Item;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.refcodes.component.Component;
import org.refcodes.component.Decomposeable;
import org.refcodes.component.Flushable;
import org.refcodes.component.Initializable;
import org.refcodes.criteria.Criteria;
import org.refcodes.criteria.ExpressionQueryFactoryImpl;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.logger.QueryLogger;
import org.refcodes.logger.alt.simpledb.SimpleDbLogger;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnFactory;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.RecordImpl;
import org.refcodes.tabular.Records;
import org.refcodes.textual.CsvBuilder;
import org.refcodes.textual.CsvEscapeMode;

public class SimpleDbQueryLogger<T>
extends SimpleDbLogger<T>
implements QueryLogger<T>,
Component,
Initializable,
Decomposeable,
Flushable {
    private static final String SQL_WILDCARD = "*";
    private static final String SQL_WHERE = "WHERE";
    private static final String SQL_FROM = "FROM";
    private static final String SQL_SELECT = "SELECT";
    private static final String SQL_LIMIT = "LIMIT";
    private static final int MAX_LIMIT = 250;
    private ExpressionQueryFactoryImpl _expressionQueryFactory = new ExpressionQueryFactoryImpl();

    public SimpleDbQueryLogger(String string, String string2, String string3, ColumnFactory<T> columnFactory) {
        super(string, string2, string3, null, columnFactory);
    }

    public SimpleDbQueryLogger(String string, String string2, String string3, String string4, ColumnFactory<T> columnFactory) {
        super(string, string2, string3, string4, columnFactory);
    }

    public Records<T> findLogs() {
        return this.findLogs(null, null, -1);
    }

    public Records<T> findLogs(int n) {
        return this.findLogs(null, null, n);
    }

    public Records<T> findLogs(Criteria criteria) {
        return this.findLogs(criteria, null, -1);
    }

    public Records<T> findLogs(Criteria criteria, int n) {
        return this.findLogs(criteria, null, n);
    }

    public Records<T> findLogs(Criteria criteria, Header<T> header) {
        return this.findLogs(criteria, header, -1);
    }

    public Records<T> findLogs(Header<T> header, int n) {
        return this.findLogs(null, header, n);
    }

    public Records<T> findLogs(Criteria criteria, Header<T> header, int n) {
        this.flushBuffer();
        String string = this.toSqlQuery(criteria, n);
        return new SimpleDbRecords(string, header);
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this._expressionQueryFactory = null;
    }

    protected String toSqlQuery(Criteria criteria, int n) {
        if (n > 250) {
            LOGGER.warn("This implementation only supports a max limit of <250>, you provided a limit of <" + n + ">, your result will be limited to the max limit.");
        }
        String string = "SELECT * FROM" + this.getAmazonSimpleDbDomainName() + " WHERE " + this._expressionQueryFactory.fromCriteria(criteria);
        if (n != -1) {
            string = string + " LIMIT " + n;
        }
        LOGGER.info("Created query \"" + string + "\"...");
        return string;
    }

    protected class SimpleDbRecords
    implements Records<T> {
        private SelectRequest _selectRequest;
        private Header<T> _header;
        private Iterator<Item> _itemPage = null;
        private String _nextToken = "";
        private Item _nextItem = null;

        public SimpleDbRecords(String string) {
            this(string, null);
        }

        public SimpleDbRecords(String string, Header<T> header) {
            this._selectRequest = new SelectRequest(string);
            this._header = header;
            this.doPrepareNext();
        }

        private void doPrepareNext() {
            this._selectRequest.setNextToken(this._nextToken);
            SelectResult selectResult = SimpleDbQueryLogger.this.getAmazonSimpleDbClient().select(this._selectRequest);
            this._nextToken = selectResult.getNextToken();
            this._itemPage = selectResult.getItems().iterator();
        }

        public boolean hasNext() {
            if (!(this._itemPage != null && this._itemPage.hasNext() || this._nextToken == null)) {
                try {
                    this.doPrepareNext();
                    return this._itemPage.hasNext();
                }
                catch (Exception exception) {
                    SimpleDbLogger.LOGGER.warn("Caught an exception (Amazon domain is \"" + SimpleDbQueryLogger.this.getAmazonSimpleDbDomainName() + "\") of type \"" + exception.getClass().getName() + "\"  on Amazon domain \"" + SimpleDbQueryLogger.this.getAmazonSimpleDbDomainName() + "\" with message: " + ExceptionUtility.toMessage((Throwable)exception), (Throwable)exception);
                    return false;
                }
            }
            return this._itemPage.hasNext();
        }

        protected synchronized Item nextItem() {
            if (this.hasNext()) {
                this._nextItem = this._itemPage.next();
                return this._nextItem;
            }
            throw new NoSuchElementException("No more elements can be retrieved from the given SimpleDB select queiry \"" + this._selectRequest.getSelectExpression() + "\"!");
        }

        public synchronized Record<T> next() {
            if (this.hasNext()) {
                RecordImpl recordImpl = new RecordImpl();
                Record record = null;
                this._nextItem = this._itemPage.next();
                for (Attribute attribute : this._nextItem.getAttributes()) {
                    Object object;
                    SimpleDbQueryLogger.this.addHeaderColumn(attribute.getName());
                    if (recordImpl.containsKey((Object)attribute.getName())) {
                        object = recordImpl.get((Object)attribute.getName());
                        if (object instanceof String[]) {
                            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList((String[])object));
                            arrayList.add(attribute.getValue());
                            recordImpl.put((Object)attribute.getName(), (Object)arrayList.toArray(new String[arrayList.size()]));
                            continue;
                        }
                        recordImpl.put((Object)attribute.getName(), (Object)new String[]{(String)object, attribute.getValue()});
                        continue;
                    }
                    if (SimpleDbQueryLogger.this.getHeader().containsKey((Object)attribute.getName())) {
                        object = (Column)SimpleDbQueryLogger.this.getHeader().get((Object)attribute.getName());
                        if (object.getType().isArray()) {
                            recordImpl.put((Object)attribute.getName(), (Object)new String[]{attribute.getValue()});
                            continue;
                        }
                        recordImpl.put((Object)attribute.getName(), (Object)new String[]{attribute.getValue()});
                        continue;
                    }
                    recordImpl.put((Object)attribute.getName(), (Object)new String[]{attribute.getValue()});
                }
                try {
                    if (this._header != null) {
                        record = this._header.fromStorageStrings((Record)recordImpl);
                        recordImpl = this._header.toSubset((Record)recordImpl);
                    } else {
                        record = SimpleDbQueryLogger.this.getHeader().fromStorageStrings((Record)recordImpl);
                    }
                }
                catch (ParseException | ColumnMismatchException | HeaderMismatchException throwable) {
                    SimpleDbLogger.LOGGER.warn("The retrieved record  on Amazon domain \"" + SimpleDbQueryLogger.this.getAmazonSimpleDbDomainName() + "\" with keys {" + new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{recordImpl.keySet()}).withDelimiter(',').toRecord() + "} and values {" + new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{recordImpl.values()}).withDelimiter(',').toRecord() + "} cannot be converted to the provided header {" + new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{this._header.keySet()}).withDelimiter(',').toRecord() + "} format.", throwable);
                }
                return record == null ? new RecordImpl() : record;
            }
            throw new NoSuchElementException("No more elements can be retrieved from the given SimpleDB select query \"" + this._selectRequest.getSelectExpression() + "\"!");
        }

        public synchronized void remove() {
            if (this._nextItem != null) {
                try {
                    SimpleDbQueryLogger.this.getAmazonSimpleDbClient().deleteAttributes(new DeleteAttributesRequest(SimpleDbQueryLogger.this.getAmazonSimpleDbDomainName(), this._nextItem.getName()));
                }
                catch (AmazonServiceException amazonServiceException) {
                    throw new NoSuchElementException("No element can be deleted from the given SimpleDB being queried with the select query \"" + this._selectRequest.getSelectExpression() + "\": " + ExceptionUtility.toMessage((Throwable)amazonServiceException));
                }
                finally {
                    this._nextItem = null;
                }
            } else {
                throw new NoSuchElementException("No element can be deleted from the given SimpleDB being queried with the select query \"" + this._selectRequest.getSelectExpression() + "\"!");
            }
        }
    }
}

