/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.slf4j.impls;

import org.refcodes.logger.Logger;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.consts.LogPriority;
import org.refcodes.logger.consts.LoggerFields;
import org.refcodes.logger.impls.RuntimeLoggerImpl;
import org.refcodes.logger.impls.RuntimeLoggerSingleton;
import org.refcodes.logger.traps.IllegalRecordRuntimeException;
import org.refcodes.logger.traps.UnexpectedLogRuntimeException;
import org.refcodes.runtime.utils.RuntimeUtility;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.traps.ColumnMismatchException;
import org.slf4j.LoggerFactory;

public class Slf4jLoggerImpl
implements Logger<Object> {
    private transient org.slf4j.Logger _logger;

    public Slf4jLoggerImpl() {
        Class[] theCallees = new Class[]{RuntimeLoggerImpl.class, RuntimeLogger.class, RuntimeLoggerSingleton.class, Slf4jLoggerImpl.class};
        Class<?> theCaller = RuntimeUtility.getCallerStackTraceElement((Class[])theCallees).getClass();
        this._logger = LoggerFactory.getLogger(theCaller);
    }

    public void log(Record<? extends Object> aRecord) throws IllegalRecordRuntimeException, UnexpectedLogRuntimeException {
        try {
            LogPriority thePriority = (LogPriority)LoggerFields.LOG_PRIORITY.getColumn().get(aRecord);
            Integer theLineNumber = (Integer)LoggerFields.LOG_LINE_NUMBER.getColumn().get(aRecord);
            String theMessage = (String)LoggerFields.LOG_MESSAGE.getColumn().get(aRecord);
            String theMethodName = (String)LoggerFields.LOG_METHODE_NAME.getColumn().get(aRecord);
            Exception theException = (Exception)LoggerFields.LOG_EXCEPTION.getColumn().get(aRecord);
            String theLogMessage = theLineNumber + " " + theMessage + "@" + theMethodName;
            switch (thePriority) {
                case PANIC: {
                    this._logger.error(theLogMessage, (Throwable)theException);
                    break;
                }
                case ALERT: {
                    this._logger.error(theLogMessage, (Throwable)theException);
                    break;
                }
                case CRITICAL: {
                    this._logger.error(theLogMessage, (Throwable)theException);
                    break;
                }
                case ERROR: {
                    this._logger.error(theLogMessage, (Throwable)theException);
                    break;
                }
                case WARN: {
                    this._logger.warn(theLogMessage, (Throwable)theException);
                    break;
                }
                case NOTICE: {
                    this._logger.info(theLogMessage, (Throwable)theException);
                    break;
                }
                case INFO: {
                    this._logger.info(theLogMessage, (Throwable)theException);
                    break;
                }
                case DEBUG: {
                    this._logger.debug(theLogMessage, (Throwable)theException);
                    break;
                }
                case TRACE: {
                    this._logger.trace(theLogMessage, (Throwable)theException);
                    break;
                }
                case NONE: {
                    break;
                }
            }
        }
        catch (ClassCastException | ColumnMismatchException e) {
            throw new IllegalRecordRuntimeException(aRecord, e);
        }
    }
}

