/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.slf4j.impls;

import java.text.MessageFormat;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.alt.slf4j.impls.Slf4jRuntimeLoggerFactoryImpl;
import org.refcodes.logger.consts.LogPriority;
import org.refcodes.logger.mixins.RuntimeLoggerAccessor;
import org.refcodes.runtime.utils.RuntimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jRuntimeLoggerImpl
implements RuntimeLogger {
    private transient Logger _logger = null;
    private transient RuntimeLogger _runtimeLogger = null;

    public Slf4jRuntimeLoggerImpl() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(Slf4jRuntimeLoggerFactoryImpl.class);
        if (theStackTraceElement == null) {
            theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(Slf4jRuntimeLoggerImpl.class);
        }
        String className = theStackTraceElement.getClassName();
        Logger aLogger = LoggerFactory.getLogger((String)className);
        this.toRuntimeLogger(aLogger);
    }

    public Slf4jRuntimeLoggerImpl(Logger aLogger) {
        this.toRuntimeLogger(aLogger);
    }

    public void log(LogPriority aPriority, String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.log((Object)aPriority, aMessage);
        } else {
            switch (aPriority) {
                case PANIC: {
                    this._logger.error(aMessage);
                    break;
                }
                case ALERT: {
                    this._logger.error(aMessage);
                    break;
                }
                case CRITICAL: {
                    this._logger.error(aMessage);
                    break;
                }
                case ERROR: {
                    this._logger.error(aMessage);
                    break;
                }
                case WARN: {
                    this._logger.warn(aMessage);
                    break;
                }
                case NOTICE: {
                    this._logger.info(aMessage);
                    break;
                }
                case INFO: {
                    this._logger.info(aMessage);
                    break;
                }
                case DEBUG: {
                    this._logger.debug(aMessage);
                    break;
                }
                case TRACE: {
                    this._logger.trace(aMessage);
                    break;
                }
                case DISCARD: {
                    break;
                }
                case NONE: {
                    this._logger.info(aMessage);
                    break;
                }
                default: {
                    this._logger.info(aMessage);
                }
            }
        }
    }

    public void log(LogPriority aPriority, String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.log((Object)aPriority, aMessage, aArguments);
        } else {
            switch (aPriority) {
                case PANIC: {
                    this._logger.error(aMessage, aArguments);
                    break;
                }
                case ALERT: {
                    this._logger.error(aMessage, aArguments);
                    break;
                }
                case CRITICAL: {
                    this._logger.error(aMessage, aArguments);
                    break;
                }
                case ERROR: {
                    this._logger.error(aMessage, aArguments);
                    break;
                }
                case WARN: {
                    this._logger.warn(aMessage, aArguments);
                    break;
                }
                case NOTICE: {
                    this._logger.info(aMessage, aArguments);
                    break;
                }
                case INFO: {
                    this._logger.info(aMessage, aArguments);
                    break;
                }
                case DEBUG: {
                    this._logger.debug(aMessage, aArguments);
                    break;
                }
                case TRACE: {
                    this._logger.trace(aMessage, aArguments);
                    break;
                }
                case DISCARD: {
                    break;
                }
                case NONE: {
                    this._logger.info(aMessage, aArguments);
                    break;
                }
                default: {
                    this._logger.info(aMessage, aArguments);
                }
            }
        }
    }

    public String getName() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.getName();
        }
        return this._logger.getName();
    }

    public LogPriority getLogPriority() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.getLogPriority();
        }
        if (this._logger.isDebugEnabled()) {
            return LogPriority.DEBUG;
        }
        if (this._logger.isErrorEnabled()) {
            return LogPriority.ERROR;
        }
        if (this._logger.isInfoEnabled()) {
            return LogPriority.INFO;
        }
        if (this._logger.isTraceEnabled()) {
            return LogPriority.TRACE;
        }
        if (this._logger.isWarnEnabled()) {
            return LogPriority.WARN;
        }
        return LogPriority.NONE;
    }

    public void log(LogPriority aPriority, String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.log(aPriority, aMessage, aThrowable);
        } else {
            switch (aPriority) {
                case PANIC: {
                    this._logger.error(aMessage, aThrowable);
                    break;
                }
                case ALERT: {
                    this._logger.error(aMessage, aThrowable);
                    break;
                }
                case CRITICAL: {
                    this._logger.error(aMessage, aThrowable);
                    break;
                }
                case ERROR: {
                    this._logger.error(aMessage, aThrowable);
                    break;
                }
                case WARN: {
                    this._logger.warn(aMessage, aThrowable);
                    break;
                }
                case NOTICE: {
                    this._logger.info(aMessage, aThrowable);
                    break;
                }
                case INFO: {
                    this._logger.info(aMessage, aThrowable);
                    break;
                }
                case DEBUG: {
                    this._logger.debug(aMessage, aThrowable);
                    break;
                }
                case TRACE: {
                    this._logger.trace(aMessage, aThrowable);
                    break;
                }
                case DISCARD: {
                    break;
                }
                case NONE: {
                    this._logger.info(aMessage, aThrowable);
                    break;
                }
                default: {
                    this._logger.info(aMessage, aThrowable);
                }
            }
        }
    }

    public void log(LogPriority aPriority, String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.log(aPriority, aMessage, aThrowable, aArguments);
        } else {
            switch (aPriority) {
                case PANIC: {
                    if (!this._logger.isErrorEnabled()) break;
                    this._logger.error(MessageFormat.format(aMessage, aArguments), aThrowable);
                    break;
                }
                case ALERT: {
                    if (!this._logger.isErrorEnabled()) break;
                    this._logger.error(MessageFormat.format(aMessage, aArguments), aThrowable);
                    break;
                }
                case CRITICAL: {
                    if (!this._logger.isErrorEnabled()) break;
                    this._logger.error(MessageFormat.format(aMessage, aArguments), aThrowable);
                    break;
                }
                case ERROR: {
                    if (!this._logger.isErrorEnabled()) break;
                    this._logger.error(MessageFormat.format(aMessage, aArguments), aThrowable);
                    break;
                }
                case WARN: {
                    if (!this._logger.isWarnEnabled()) break;
                    this._logger.warn(MessageFormat.format(aMessage, aArguments), aThrowable);
                    break;
                }
                case NOTICE: {
                    if (!this._logger.isInfoEnabled()) break;
                    this._logger.info(MessageFormat.format(aMessage, aArguments), aThrowable);
                    break;
                }
                case INFO: {
                    if (!this._logger.isInfoEnabled()) break;
                    this._logger.info(MessageFormat.format(aMessage, aArguments), aThrowable);
                    break;
                }
                case DEBUG: {
                    if (!this._logger.isDebugEnabled()) break;
                    this._logger.debug(MessageFormat.format(aMessage, aArguments), aThrowable);
                    break;
                }
                case TRACE: {
                    if (!this._logger.isTraceEnabled()) break;
                    this._logger.trace(MessageFormat.format(aMessage, aArguments), aThrowable);
                    break;
                }
                case DISCARD: {
                    break;
                }
                case NONE: {
                    if (!this._logger.isInfoEnabled()) break;
                    this._logger.info(MessageFormat.format(aMessage, aArguments), aThrowable);
                    break;
                }
                default: {
                    if (!this._logger.isInfoEnabled()) break;
                    this._logger.info(MessageFormat.format(aMessage, aArguments), aThrowable);
                }
            }
        }
    }

    public boolean isLog(LogPriority aPriority) {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLog(aPriority);
        }
        return aPriority.getPriority() >= this.getLogPriority().getPriority() && aPriority.getPriority() >= 0;
    }

    public void trace(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.trace(aMessage);
        } else {
            this._logger.trace(aMessage);
        }
    }

    public void trace(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.trace(aMessage, aArguments);
        } else {
            this._logger.trace(aMessage, aArguments);
        }
    }

    public boolean isLogTrace() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogTrace();
        }
        return this.isLog(LogPriority.TRACE);
    }

    public void debug(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.debug(aMessage);
        } else {
            this._logger.debug(aMessage);
        }
    }

    public void debug(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.debug(aMessage, aArguments);
        } else {
            this._logger.debug(aMessage, aArguments);
        }
    }

    public boolean isLogDebug() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogDebug();
        }
        return this.isLog(LogPriority.DEBUG);
    }

    public void info(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.info(aMessage);
        } else {
            this._logger.info(aMessage);
        }
    }

    public void info(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.info(aMessage, aArguments);
        } else {
            this._logger.info(aMessage, aArguments);
        }
    }

    public boolean isLogInfo() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogInfo();
        }
        return this.isLog(LogPriority.INFO);
    }

    public void notice(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.notice(aMessage);
        } else {
            this._logger.info(aMessage);
        }
    }

    public void notice(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.notice(aMessage, aArguments);
        } else {
            this._logger.info(aMessage, aArguments);
        }
    }

    public boolean isLogNotice() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogNotice();
        }
        return this.isLog(LogPriority.NOTICE);
    }

    public void warn(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.warn(aMessage);
        } else {
            this._logger.warn(aMessage);
        }
    }

    public void warn(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.warn(aMessage, aArguments);
        } else {
            this._logger.warn(aMessage, aArguments);
        }
    }

    public void warn(String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.warn(aMessage, aThrowable);
        } else {
            this._logger.warn(aMessage, aThrowable);
        }
    }

    public void warn(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.warn(aMessage, aArguments);
        } else {
            this._logger.warn(MessageFormat.format(aMessage, aArguments), aThrowable);
        }
    }

    public boolean isLogWarn() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogWarn();
        }
        return this.isLog(LogPriority.WARN);
    }

    public void error(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.error(aMessage);
        } else {
            this._logger.error(aMessage);
        }
    }

    public void error(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.error(aMessage, aArguments);
        } else {
            this._logger.error(aMessage, aArguments);
        }
    }

    public void error(String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.error(aMessage, aThrowable);
        } else {
            this._logger.error(aMessage, aThrowable);
        }
    }

    public void error(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.error(aMessage, aThrowable, aArguments);
        } else {
            this._logger.error(MessageFormat.format(aMessage, aArguments), aThrowable);
        }
    }

    public boolean isLogError() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogError();
        }
        return this.isLog(LogPriority.ERROR);
    }

    public void critical(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.critical(aMessage);
        } else {
            this._logger.error(aMessage);
        }
    }

    public void critical(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.critical(aMessage, aArguments);
        } else {
            this._logger.error(aMessage, aArguments);
        }
    }

    public void critical(String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.critical(aMessage, aThrowable);
        } else {
            this._logger.error(aMessage, aThrowable);
        }
    }

    public void critical(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.critical(aMessage, aThrowable, aArguments);
        } else {
            this._logger.error(MessageFormat.format(aMessage, aArguments), aThrowable);
        }
    }

    public boolean isLogCritical() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogCritical();
        }
        return this.isLog(LogPriority.CRITICAL);
    }

    public void alert(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.alert(aMessage);
        } else {
            this._logger.error(aMessage);
        }
    }

    public void alert(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.alert(aMessage, aArguments);
        } else {
            this._logger.error(aMessage, aArguments);
        }
    }

    public void alert(String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.alert(aMessage, aThrowable);
        } else {
            this._logger.error(aMessage, aThrowable);
        }
    }

    public void alert(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.alert(aMessage, aThrowable, aArguments);
        } else {
            this._logger.error(MessageFormat.format(aMessage, aArguments), aThrowable);
        }
    }

    public boolean isLogAlert() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogAlert();
        }
        return this.isLog(LogPriority.ALERT);
    }

    public void panic(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.panic(aMessage);
        } else {
            this._logger.error(aMessage);
        }
    }

    public void panic(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.panic(aMessage, aArguments);
        } else {
            this._logger.error(aMessage, aArguments);
        }
    }

    public void panic(String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.panic(aMessage, aThrowable);
        } else {
            this._logger.error(aMessage, aThrowable);
        }
    }

    public void panic(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.panic(aMessage, aThrowable, aArguments);
        } else {
            this._logger.error(MessageFormat.format(aMessage, aArguments), aThrowable);
        }
    }

    public boolean isLogPanic() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogPanic();
        }
        return this.isLog(LogPriority.PANIC);
    }

    private void toRuntimeLogger(Logger aLogger) {
        if (aLogger instanceof RuntimeLoggerAccessor && ((RuntimeLoggerAccessor)aLogger).getRuntimeLogger() != null) {
            this._runtimeLogger = ((RuntimeLoggerAccessor)aLogger).getRuntimeLogger();
        } else {
            this._logger = aLogger;
        }
    }
}

