// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.logger.alt.slf4j.impls;

import java.util.Properties;

import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactory;

/**
 * @author steiner
 *
 */
public class Slf4jRuntimeLoggerFactorySingleton extends Slf4jRuntimeLoggerFactoryImpl {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private static Slf4jRuntimeLoggerFactorySingleton _runtimeLoggerFactorySingleton = new Slf4jRuntimeLoggerFactorySingleton();

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTOR:
	// /////////////////////////////////////////////////////////////////////////

	protected Slf4jRuntimeLoggerFactorySingleton() {}

	/**
	 * Returns the singleton's instance as fabricated by this
	 * {@link Slf4jRuntimeLoggerFactorySingleton}.
	 * 
	 * @return The {@link RuntimeLoggerFactory} singleton's instance.
	 */
	public static RuntimeLoggerFactory getInstance() {
		return _runtimeLoggerFactorySingleton;
	}

	/**
	 * Convenience method actually delegating the call to the instance returned
	 * by {@link #getInstance()}
	 * 
	 * @see RuntimeLoggerFactory#createInstance()
	 */
	public static RuntimeLogger createRuntimeLogger() {
		return getInstance().createInstance();
	}

	/**
	 * Convenience method actually delegating the call to the instance returned
	 * by {@link #getInstance()}
	 * 
	 * @see RuntimeLoggerFactory#createInstance(Properties))
	 */
	public static RuntimeLogger createRuntimeLogger( Properties aProperties ) {
		return getInstance().createInstance( aProperties );
	}

	/**
	 * Convenience method actually delegating the call to the instance returned
	 * by {@link #getInstance()}
	 * 
	 * @see RuntimeLoggerFactory#createInstance(String))
	 */
	public static RuntimeLogger createRuntimeLogger( String aIdentifier ) {
		return getInstance().createInstance( aIdentifier );
	}

	/**
	 * Convenience method actually delegating the call to the instance returned
	 * by {@link #getInstance()}
	 * 
	 * @see RuntimeLoggerFactory#createInstance(String, Properties))
	 */
	public RuntimeLogger createRuntimeLogger( String aIdentifier, Properties aProperties ) {
		return getInstance().createInstance( aIdentifier, aProperties );
	}
}
