/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.refcodes.exception.BugException;
import org.refcodes.logger.LogPriority;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerAccessor;
import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.spi.LocationAwareLogger;

public final class RuntimeLoggerAdapter
extends MarkerIgnoringBase
implements RuntimeLoggerAccessor,
LocationAwareLogger {
    private static final long serialVersionUID = 1L;
    final transient RuntimeLogger logger;

    public RuntimeLoggerAdapter(RuntimeLogger logger) {
        this.logger = logger;
        this.name = logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isLogTrace();
    }

    public void trace(String msg) {
        this.logger.trace(msg);
    }

    public void trace(String format, Object arg) {
        this.logger.trace(format, new Object[]{arg});
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logger.trace(format, new Object[]{arg1, arg2});
    }

    public void trace(String format, Object ... args) {
        this.logger.trace(format, args);
    }

    public void trace(String msg, Throwable t) {
        this.logger.trace(msg, new Object[]{t});
    }

    public boolean isDebugEnabled() {
        return this.logger.isLogDebug();
    }

    public void debug(String msg) {
        this.logger.debug(msg);
    }

    public void debug(String format, Object arg) {
        this.logger.debug(format, new Object[]{arg});
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logger.debug(format, new Object[]{arg1, arg2});
    }

    public void debug(String format, Object ... args) {
        this.logger.debug(format, args);
    }

    public void debug(String msg, Throwable t) {
        this.logger.debug(msg, new Object[]{t});
    }

    public boolean isInfoEnabled() {
        return this.logger.isLogInfo();
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void info(String format, Object arg) {
        this.logger.info(format, new Object[]{arg});
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logger.info(format, new Object[]{arg1, arg2});
    }

    public void info(String format, Object ... args) {
        this.logger.info(format, args);
    }

    public void info(String msg, Throwable t) {
        this.logger.info(msg, new Object[]{t});
    }

    public boolean isWarnEnabled() {
        return this.logger.isLogWarn();
    }

    public void warn(String msg) {
        this.logger.warn(msg);
    }

    public void warn(String format, Object arg) {
        this.logger.warn(format, new Object[]{arg});
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logger.warn(format, new Object[]{arg1, arg2});
    }

    public void warn(String format, Object ... args) {
        this.logger.warn(format, args);
    }

    public void warn(String msg, Throwable t) {
        this.logger.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLogError();
    }

    public void error(String msg) {
        this.logger.error(msg);
    }

    public void error(String format, Object arg) {
        this.logger.error(format, new Object[]{arg});
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logger.error(format, new Object[]{arg1, arg2});
    }

    public void error(String format, Object ... args) {
        this.logger.error(format, args);
    }

    public void error(String msg, Throwable t) {
        this.logger.error(msg, t);
    }

    public void log(Marker aMarker, String aCallerFQCN, int aLevel, String aMessage, Object[] aArgs, Throwable aThrowable) {
        this.logger.log(switch (aLevel) {
            case 0 -> LogPriority.TRACE;
            case 10 -> LogPriority.DEBUG;
            case 20 -> LogPriority.INFO;
            case 30 -> LogPriority.WARN;
            case 40 -> LogPriority.ERROR;
            default -> throw new BugException("Missing case statement for <" + aLevel + "> in implementation!");
        }, aMessage, aThrowable, aArgs);
    }

    public RuntimeLogger getRuntimeLogger() {
        return this.logger;
    }
}

