/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.slf4j.helpers.NOPLogger;
import org.slf4j.impl.RuntimeLoggerAdapter;

public class RuntimeLoggerFactory
implements ILoggerFactory {
    private ConcurrentMap<String, Logger> _nameToLoggerMap = new ConcurrentHashMap<String, Logger>();
    private static final ThreadLocal<Integer> _invocationCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public RuntimeLoggerFactory() {
        SLF4JBridgeHandler.install();
    }

    public Logger getLogger(String name) {
        if (_invocationCount.get() != 0) {
            return NOPLogger.NOP_LOGGER;
        }
        _invocationCount.set(_invocationCount.get() + 1);
        Logger slf4jLogger = (Logger)this._nameToLoggerMap.get(name);
        if (slf4jLogger != null) {
            _invocationCount.remove();
            return slf4jLogger;
        }
        if (name != null) {
            name = name.replaceAll("/", ".");
        }
        if (name.length() > 0 && name.charAt(0) == '.') {
            name = name.substring(1);
        }
        if (name == null || name.length() == 0) {
            name = "root";
        }
        RuntimeLogger theRuntimeLogger = name.equalsIgnoreCase("ROOT") ? RuntimeLoggerFactorySingleton.createRuntimeLogger() : (RuntimeLogger)RuntimeLoggerFactorySingleton.getInstance().createInstance((Object)name);
        RuntimeLoggerAdapter newInstance = new RuntimeLoggerAdapter(theRuntimeLogger);
        Logger oldInstance = this._nameToLoggerMap.putIfAbsent(name, (Logger)newInstance);
        _invocationCount.remove();
        return oldInstance == null ? newInstance : oldInstance;
    }
}

