/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.Serializable;
import org.refcodes.logger.LogPriority;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerAccessor;
import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.spi.LocationAwareLogger;

public final class RuntimeLoggerAdapter
extends MarkerIgnoringBase
implements RuntimeLoggerAccessor,
LocationAwareLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    final transient RuntimeLogger logger;

    public RuntimeLoggerAdapter(RuntimeLogger logger) {
        this.logger = logger;
        this.name = logger.getName();
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String msg) {
        this.logger.trace(msg);
    }

    public void trace(String format, Object arg) {
        this.logger.trace(format, new Object[]{arg});
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logger.trace(format, new Object[]{arg1, arg2});
    }

    public void trace(String format, Object ... args) {
        this.logger.trace(format, args);
    }

    public void trace(String msg, Throwable t) {
        this.logger.trace(msg, new Object[]{t});
    }

    public boolean isDebugEnabled() {
        return this.logger.isLogDebug();
    }

    public void debug(String msg) {
        this.logger.debug(msg);
    }

    public void debug(String format, Object arg) {
        this.logger.debug(format, new Object[]{arg});
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logger.debug(format, new Object[]{arg1, arg2});
    }

    public void debug(String format, Object ... args) {
        this.logger.debug(format, args);
    }

    public void debug(String msg, Throwable t) {
        this.logger.debug(msg, new Object[]{t});
    }

    public boolean isInfoEnabled() {
        return this.logger.isLogInfo();
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void info(String format, Object arg) {
        this.logger.info(format, new Object[]{arg});
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logger.info(format, new Object[]{arg1, arg2});
    }

    public void info(String format, Object ... args) {
        this.logger.info(format, args);
    }

    public void info(String msg, Throwable t) {
        this.logger.info(msg, new Object[]{t});
    }

    public boolean isWarnEnabled() {
        return this.logger.isLogWarn();
    }

    public void warn(String msg) {
        this.logger.warn(msg);
    }

    public void warn(String format, Object arg) {
        this.logger.warn(format, new Object[]{arg});
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logger.warn(format, new Object[]{arg1, arg2});
    }

    public void warn(String format, Object ... args) {
        this.logger.warn(format, args);
    }

    public void warn(String msg, Throwable t) {
        this.logger.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLogError();
    }

    public void error(String msg) {
        this.logger.error(msg);
    }

    public void error(String format, Object arg) {
        this.logger.error(format, new Object[]{arg});
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logger.error(format, new Object[]{arg1, arg2});
    }

    public void error(String format, Object ... args) {
        this.logger.error(format, args);
    }

    public void error(String msg, Throwable t) {
        this.logger.error(msg, t);
    }

    public void log(Marker marker, String callerFQCN, int level, String msg, Object[] args, Throwable t) {
        LogPriority logPriority;
        switch (level) {
            case 0: {
                logPriority = LogPriority.TRACE;
                break;
            }
            case 10: {
                logPriority = LogPriority.DEBUG;
                break;
            }
            case 20: {
                logPriority = LogPriority.INFO;
                break;
            }
            case 30: {
                logPriority = LogPriority.WARN;
                break;
            }
            case 40: {
                logPriority = LogPriority.ERROR;
                break;
            }
            default: {
                throw new IllegalStateException("Level number " + level + " is not recognized.");
            }
        }
        this.logger.log(logPriority, msg, t);
    }

    public RuntimeLogger getRuntimeLogger() {
        return this.logger;
    }
}

