// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.logger.impls;

import static org.junit.Assert.assertNotSame;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.fail;

import org.junit.Test;
import org.refcodes.logger.RuntimeLogger;

/**
 * @author steiner
 *
 */
public class RuntimeLoggerFactorySingletonTest {

	@Test
	public void createInstance() {
		RuntimeLogger theBar = RuntimeLoggerFactorySingleton.getInstance().createInstance( "com.acme.foo.bar" );
		RuntimeLogger theFoo = RuntimeLoggerFactorySingleton.getInstance().createInstance( "com.acme.foo" );
		RuntimeLogger theAcme = RuntimeLoggerFactorySingleton.getInstance().createInstance( "com.acme" );
		RuntimeLogger theCom = RuntimeLoggerFactorySingleton.getInstance().createInstance( "com" );
		RuntimeLogger theOrg = RuntimeLoggerFactorySingleton.getInstance().createInstance( "org" );
		RuntimeLogger theRoot = RuntimeLoggerFactorySingleton.createRuntimeLogger();
		RuntimeLogger theDot = RuntimeLoggerFactorySingleton.getInstance().createInstance( "." );
		RuntimeLogger theNop = RuntimeLoggerFactorySingleton.getInstance().createInstance( "" );
		try {
			RuntimeLoggerFactorySingleton.getInstance().createInstance( (String) null );
			fail( "The identifier must not be null." );
		}
		catch ( IllegalArgumentException e ) { /* expected */}
		assertSame( theBar, theFoo );
		assertSame( theBar, theAcme );
		assertSame( theRoot, theCom );
		assertSame( theRoot, theOrg );
		assertSame( theRoot, theDot );
		assertSame( theRoot, theNop );
		assertNotSame( theBar, theRoot );
	}
}
