// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.logger.impls;

import java.util.Collection;

import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.logger.LoggerFactory;
import org.refcodes.logger.TrimLogger;
import org.refcodes.tabular.Column;

/**
 * This {@link TestPartedTrimLoggerImpl} is required to make the
 * {@link #getLoggers()} method available to the test cases.
 */
public class TestPartedTrimLoggerImpl extends PartedTrimLoggerImpl<Object, String> {

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public TestPartedTrimLoggerImpl( Column<String> aPartitionColumn, LoggerFactory<TrimLogger<Object>> aLoggerFactory, boolean isPartitionAutoInitialize ) {
		super( aPartitionColumn, aLoggerFactory, isPartitionAutoInitialize );
	}

	public TestPartedTrimLoggerImpl( Column<String> aPartitionColumn, String aDefaultLoggerName, LoggerFactory<TrimLogger<Object>> aLoggerFactory, boolean isPartitionAutoInitialize ) {
		super( aPartitionColumn, aDefaultLoggerName, aLoggerFactory, isPartitionAutoInitialize );
	}

	public TestPartedTrimLoggerImpl( ExecutionStrategy aComponentExecutionStrategy, Column<String> aPartitionColumn, LoggerFactory<TrimLogger<Object>> aLoggerFactory, boolean isPartitionAutoInitialize ) {
		super( aComponentExecutionStrategy, aPartitionColumn, aLoggerFactory, isPartitionAutoInitialize );
	}

	public TestPartedTrimLoggerImpl( ExecutionStrategy aComponentExecutionStrategy, Column<String> aPartitionColumn, String aDefaultLoggerName, LoggerFactory<TrimLogger<Object>> aLoggerFactory, boolean isPartitionAutoInitialize ) {
		super( aComponentExecutionStrategy, aPartitionColumn, aDefaultLoggerName, aLoggerFactory, isPartitionAutoInitialize );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public Collection<TrimLogger<Object>> getLoggers() {
		return super.getLoggers();
	}
}
