// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.logger.impls;

import java.util.Properties;

import org.refcodes.data.TextConsts;
import org.refcodes.logger.LoggerFactory;
import org.refcodes.logger.TrimLogger;

/**
 * The {@link LoggerFactory} implementation for creating
 * {@link TestTrimLoggerImpl} instances, the {@link TestTrimLoggerFactoryImpl}
 * is for example required for testing the {@link PartedTrimLoggerImpl} class.
 */
public class TestTrimLoggerFactoryImpl implements LoggerFactory<TrimLogger<Object>> {

	@Override
	public TrimLogger<Object> createInstance( String aIdentifier ) {
		return new TestTrimLoggerImpl( aIdentifier );
	}

	@Override
	public TrimLogger<Object> createInstance( String aIdentifier, Properties aProperties ) {
		throw new UnsupportedOperationException( TextConsts.UNSUPPORTED_OPERATION );
	}

}
