// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.logger.impls;

import org.refcodes.component.CompositeComponent;
import org.refcodes.component.InitializeException;
import org.refcodes.component.OpenException;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.criteria.Criteria;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.TrimLogger;
import org.refcodes.logger.UnexpectedLogRuntimeException;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.Records;
import org.refcodes.tabular.impls.RecordImpl;
import org.refcodes.tabular.impls.RecordsImpl;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.impls.HorizAlignTextBuilderImpl;

/**
 * The {@link TestTrimLoggerImpl} implements the {@link TrimLogger} interface
 * and is used for testing the various logger functionalities regarding
 * partitioning and clustering (composite). The actual log content is not
 * regarded by this logger, moreover calls to its methods are counted to be able
 * to determine whether the various instances are called as expected when being
 * encapsulated for example in a {@link PartedTrimLoggerImpl} or a
 * {@link CompositeTrimLoggerImpl}.
 */
public class TestTrimLoggerImpl implements TrimLogger<Object>, CompositeComponent {

	private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String _loggerName;

	private int _findLogsCount = 0;
	private int _clearCount = 0;
	private int _deleteLogsCount = 0;
	private int _logCount = 0;

	private int _initializeCount = 0;
	private int _startCount = 0;
	private int _pauseCount = 0;
	private int _resumeCount = 0;
	private int _stopCount = 0;
	private int _destroyCount = 0;
	private int _flushCount = 0;
	private int _decomposeCount = 0;
	private int _resetCount = 0;
	private int _openCount = 0;
	private int _closeCount = 0;
	private int _disposeCount = 0;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public TestTrimLoggerImpl( int aLoggerNumber ) {
		_loggerName = RuntimeUtility.toClassName() + "-" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + aLoggerNumber ).withColumnWidth( 5 ).withFillChar( '0' ).toString();
	}

	public TestTrimLoggerImpl( String aLoggerName ) {
		_loggerName = aLoggerName;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHOD COUNTERS:
	// /////////////////////////////////////////////////////////////////////////

	public int getFindLogsCount() {
		return _findLogsCount;
	}

	public int getClearCount() {
		return _clearCount;
	}

	public int getDeleteLogsCount() {
		return _deleteLogsCount;
	}

	public int getLogCount() {
		return _logCount;
	}

	public int getInitializeCount() {
		return _initializeCount;
	}

	public int getStartCount() {
		return _startCount;
	}

	public int getPauseCount() {
		return _pauseCount;
	}

	public int getResumeCount() {
		return _resumeCount;
	}

	public int getStopCount() {
		return _stopCount;
	}

	public int getDestroyCount() {
		return _destroyCount;
	}

	public int getFlushCount() {
		return _flushCount;
	}

	public int getDecomposeCount() {
		return _decomposeCount;
	}

	public int getResetCount() {
		return _resetCount;
	}

	public int getDisposeCount() {
		return _disposeCount;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public Records<Object> findLogs() {
		_findLogsCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _findLogsCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
		return null;
	}

	@Override
	public Records<Object> findLogs( int aLimit ) {
		_findLogsCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _findLogsCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
		return new RecordsImpl<Object>( new RecordImpl<Object>() );
	}

	@Override
	public Records<Object> findLogs( Header<Object> aHeader, int aLimit ) {
		_findLogsCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _findLogsCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
		return new RecordsImpl<Object>( new RecordImpl<Object>() );
	}

	@Override
	public Records<Object> findLogs( Criteria aCriteria ) {
		_findLogsCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _findLogsCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
		return new RecordsImpl<Object>( new RecordImpl<Object>() );
	}

	@Override
	public Records<Object> findLogs( Criteria aCriteria, int aLimit ) {
		_findLogsCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _findLogsCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
		return new RecordsImpl<Object>( new RecordImpl<Object>() );
	}

	@Override
	public Records<Object> findLogs( Criteria aCriteria, Header<Object> aHeader ) {
		_findLogsCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _findLogsCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
		return new RecordsImpl<Object>( new RecordImpl<Object>() );
	}

	@Override
	public Records<Object> findLogs( Criteria aCriteria, Header<Object> aHeader, int aLimit ) {
		_findLogsCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _findLogsCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
		return new RecordsImpl<Object>( new RecordImpl<Object>() );
	}

	@Override
	public void log( Record<? extends Object> aRecord ) throws IllegalRecordRuntimeException, UnexpectedLogRuntimeException {
		_logCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _logCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void clear() {
		_clearCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _clearCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void deleteLogs( Criteria aCriteria ) {
		_deleteLogsCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _deleteLogsCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	// /////////////////////////////////////////////////////////////////////////
	// COMPONENT:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public void initialize() throws InitializeException {
		_initializeCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _initializeCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void start() throws StartException {
		_startCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _startCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void pause() throws PauseException {
		_pauseCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _pauseCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void resume() throws ResumeException {
		_resumeCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _resumeCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void stop() throws StopException {
		_stopCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _stopCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void destroy() {
		_destroyCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _destroyCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void flush() throws OpenException {
		_flushCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _flushCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void decompose() {
		_decomposeCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _decomposeCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void reset() {
		_resetCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _resetCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void open() throws OpenException {
		_openCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _openCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void close() {
		_closeCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _closeCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}

	@Override
	public void dispose() {
		_disposeCount++;
		LOGGER.debug( _loggerName + " [" + new HorizAlignTextBuilderImpl().withHorizAlignTextMode( HorizAlignTextMode.LEFT ).withText( "" + _disposeCount ).withColumnWidth( 5 ).withFillChar( '0' ).toString() + "]" );
	}
}
