/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.refcodes.configuration.Properties;
import org.refcodes.data.Delimiter;
import org.refcodes.logger.LoggerInstantiationRuntimeException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactory;
import org.refcodes.logger.RuntimeLoggerImpl;
import org.refcodes.logger.RuntimeLoggerUtility;
import org.refcodes.logger.SystemLoggerImpl;
import org.refcodes.runtime.RuntimeUtility;

public class RuntimeLoggerFactoryImpl
implements RuntimeLoggerFactory {
    private static final RuntimeLoggerImpl FALLBACK_RUNTIME_LOGGER = new RuntimeLoggerImpl(new SystemLoggerImpl());
    private static final String SKIP_LOGGER_CONFIG_FILE_LIB = "org.apache.commons.configuration.DefaultFileSystem";
    private ConcurrentHashMap<String, RuntimeLogger> _nameToRuntimeLoggerMap = new ConcurrentHashMap();

    protected RuntimeLoggerFactoryImpl() {
    }

    public RuntimeLogger createInstance() {
        String className = RuntimeUtility.getCallerStackTraceElement((String)RuntimeLoggerFactoryImpl.class.getPackage().getName()).getClassName();
        return this.createInstance(className, (Properties)null);
    }

    public RuntimeLogger createInstance(Properties aProperties) {
        String className = RuntimeUtility.getCallerStackTraceElement(RuntimeLoggerFactoryImpl.class).getClassName();
        return this.createInstance(className, aProperties);
    }

    public RuntimeLogger createInstance(String aIdentifier) {
        return this.createInstance(aIdentifier, null);
    }

    public RuntimeLogger createInstance(String aIdentifier, Properties aProperties) {
        if (aIdentifier == null) {
            throw new IllegalArgumentException("The identifier must not be null; please provide a valid identifier.");
        }
        RuntimeLogger theRuntimeLogger = this._nameToRuntimeLoggerMap.get(aIdentifier);
        if (theRuntimeLogger != null) {
            return theRuntimeLogger;
        }
        ArrayList<String> theNames = new ArrayList<String>();
        String eIdentifier = aIdentifier.replace(Delimiter.INNER_CLASS.getChar(), Delimiter.PACKAGE_HIERARCHY.getChar());
        int i = aIdentifier.length();
        while (i > 0) {
            eIdentifier = eIdentifier.substring(0, i);
            theNames.add(eIdentifier);
            theRuntimeLogger = this._nameToRuntimeLoggerMap.get(eIdentifier);
            if (theRuntimeLogger != null) break;
            try {
                theRuntimeLogger = RuntimeLoggerUtility.fromConfigurationFile(eIdentifier, "runtimelogger-config.xml");
                break;
            }
            catch (LoggerInstantiationRuntimeException loggerInstantiationRuntimeException) {
                i = eIdentifier.lastIndexOf(Delimiter.NAMESPACE.getChar());
            }
        }
        if (theRuntimeLogger == null) {
            if (SKIP_LOGGER_CONFIG_FILE_LIB.equals(aIdentifier)) {
                return FALLBACK_RUNTIME_LOGGER;
            }
            if (!"root".equals(aIdentifier) && (theRuntimeLogger = this._nameToRuntimeLoggerMap.get("root")) == null) {
                try {
                    theRuntimeLogger = RuntimeLoggerUtility.fromConfigurationFile("root", "runtimelogger-config.xml");
                }
                catch (LoggerInstantiationRuntimeException e) {
                    SystemLoggerImpl theLogger = new SystemLoggerImpl();
                    theRuntimeLogger = new RuntimeLoggerImpl(theLogger);
                    theRuntimeLogger.alert("Attention: Using fallback \"System.out\"/\"System.err\" runtime logger: " + this.toCreateRuntimeLoggerErrorMessage(aIdentifier), (Throwable)((Object)e));
                }
                if (theRuntimeLogger == null) {
                    throw new LoggerInstantiationRuntimeException(this.toCreateRuntimeLoggerErrorMessage(aIdentifier));
                }
                theNames.add("root");
            }
        }
        for (String eName : theNames) {
            this._nameToRuntimeLoggerMap.putIfAbsent(eName, theRuntimeLogger);
        }
        RuntimeLogger theRaceWinner = this._nameToRuntimeLoggerMap.get(aIdentifier);
        return theRaceWinner != null ? theRaceWinner : theRuntimeLogger;
    }

    private String toCreateRuntimeLoggerErrorMessage(String aIdentifier) {
        return "Unable to create the runtime logger as the configuration \"runtimelogger-config.xml\" does not seem to contain any valid runtime logger configuration for a runtime logger of name \"" + aIdentifier + "\" (or any of its higher hiearchy levels) or the root logger at \"" + "root" + "\".";
    }
}

