// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.logger;

/**
 * Provides an accessor for a {@link LogPriority} property.
 */
public interface LogPriorityAccessor {

	/**
	 * Retrieves the {@link LogPriority} from the {@link LogPriorityAccessor}.
	 * 
	 * @return The {@link LogPriority} stored by the {@link LogPriorityAccessor}
	 *         .
	 */
	LogPriority getLogPriority();

	/**
	 * Provides a mutator for a {@link LogPriority} property.
	 */
	public interface LogPriorityMutator {

		/**
		 * Sets the {@link LogPriority} for the {@link LogPriorityAccessor}.
		 * 
		 * @param aPriority The {@link LogPriority} to be stored by the
		 *        {@link LogPriorityAccessor}.
		 */
		void setLogPriority( LogPriority aPriority );
	}

	/**
	 * Provides a {@link LogPriority} property.
	 */
	public interface LogPriorityProperty extends LogPriorityAccessor, LogPriorityMutator {

		/**
		 * This method stores and passes through the given argument, which is
		 * very useful for builder APIs: Sets the given value (setter) as of
		 * {@link #setLogPriority(LogPriority)} and returns the very same value
		 * (getter).
		 * 
		 * @param aLogPriority The value to set (via
		 *        {@link #setLogPriority(LogPriority)}).
		 * 
		 * @return Returns the value passed for it to be used in conclusive
		 *         processing steps.
		 */
		default LogPriority letLogPriority( LogPriority aLogPriority ) {
			setLogPriority( aLogPriority );
			return aLogPriority;
		}
	}
}
