// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.logger;

import java.text.ParseException;

import org.refcodes.tabular.AbstractColumn;
import org.refcodes.tabular.Column;

/**
 * Implementation of a {@link Column} interface for working with
 * {@link LogPriority} instances, being {@link Cloneable}.
 */
public class LogPriorityColumnImpl extends AbstractColumn<LogPriority> implements Cloneable {

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Creates a {@link LogPriorityColumnImpl} managing {@link String}
	 * instances.
	 * 
	 * @param aKey The key for the {@link LogPriorityColumnImpl}.
	 */
	public LogPriorityColumnImpl( String aKey ) {
		super( aKey, LogPriority.class );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public synchronized String[] toStorageStrings( LogPriority aValue ) {
		return new String[] {
				aValue.toString()
		};
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public synchronized LogPriority fromStorageStrings( String[] aStringValues ) throws ParseException {
		if ( aStringValues == null || aStringValues.length == 0 ) {
			return null;
		}
		else if ( aStringValues.length == 1 ) {
			return LogPriority.valueOf( aStringValues[0].trim() );
		}
		throw new IllegalArgumentException( "The type <" + getType().getName() + "> is not an array type though the number of elements in the provided string array is <" + aStringValues.length + "> whereas only one element is being expected." );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}
}