// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.logger;

import org.refcodes.factory.LookupFactory;

/**
 * A {@link LoggerFactory} defines the methods required to factor {@link Logger}
 * instances. You might also provide a static method with the following
 * signature in order to provide singleton functionality and avoid to create too
 * many unnecessary {@link Logger} instances:
 * <p>
 * public {@link Logger} getInstance() { ... }
 *
 * @param <L> the generic type
 */
public interface LoggerFactory<L extends Logger<?>> extends LookupFactory<L, String> {}
