// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.logger;

/**
 * Thrown in case instantiating a {@link Logger} ({@link RuntimeLogger}) failed,
 * e.g. the {@link RuntimeLoggerSingleton} tries to construct a
 * {@link RuntimeLogger} from a bean configuration file (or a
 * SpringRuntimeLoggerSingleton tries to construct a {@link RuntimeLogger} from
 * a bean configuration context file) and fails doing so (due to missing or
 * "wrong" configuration file).
 */
public class LoggerInstantiationRuntimeException extends LoggerRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new logger instantiation runtime exception.
	 *
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public LoggerInstantiationRuntimeException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new logger instantiation runtime exception.
	 *
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public LoggerInstantiationRuntimeException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new logger instantiation runtime exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public LoggerInstantiationRuntimeException( String message, Throwable cause ) {
		super( message, cause );
	}

	/**
	 * Instantiates a new logger instantiation runtime exception.
	 *
	 * @param message the message
	 */
	public LoggerInstantiationRuntimeException( String message ) {
		super( message );
	}

	/**
	 * Instantiates a new logger instantiation runtime exception.
	 *
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public LoggerInstantiationRuntimeException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new logger instantiation runtime exception.
	 *
	 * @param cause the cause
	 */
	public LoggerInstantiationRuntimeException( Throwable cause ) {
		super( cause );
	}
}
