// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.logger;

import org.refcodes.exception.AbstractRuntimeException;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.RecordAccessor;

/**
 * The Class LoggerRuntimeException.
 */
public abstract class LoggerRuntimeException extends AbstractRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new logger runtime exception.
	 *
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public LoggerRuntimeException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new logger runtime exception.
	 *
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public LoggerRuntimeException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new logger runtime exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public LoggerRuntimeException( String message, Throwable cause ) {
		super( message, cause );
	}

	/**
	 * Instantiates a new logger runtime exception.
	 *
	 * @param message the message
	 */
	public LoggerRuntimeException( String message ) {
		super( message );
	}

	/**
	 * Instantiates a new logger runtime exception.
	 *
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public LoggerRuntimeException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new logger runtime exception.
	 *
	 * @param cause the cause
	 */
	public LoggerRuntimeException( Throwable cause ) {
		super( cause );
	}

	/**
	 * The Class LoggerRecordRuntimeException.
	 */
	@SuppressWarnings("rawtypes")
	static abstract class LoggerRecordRuntimeException extends LoggerRuntimeException implements RecordAccessor {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////////

		private Record<?> _dataRecord;

		// /////////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////////

		/**
		 * Instantiates a new logger record runtime exception.
		 *
		 * @param aDataRecord the data record
		 * @param aMessage the message
		 * @param aErrorCode the error code
		 */
		public LoggerRecordRuntimeException( Record<?> aDataRecord, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_dataRecord = aDataRecord;
		}

		/**
		 * Instantiates a new logger record runtime exception.
		 *
		 * @param aDataRecord the data record
		 * @param aMessage the message
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public LoggerRecordRuntimeException( Record<?> aDataRecord, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_dataRecord = aDataRecord;
		}

		/**
		 * Instantiates a new logger record runtime exception.
		 *
		 * @param aDataRecord the data record
		 * @param message the message
		 * @param cause the cause
		 */
		public LoggerRecordRuntimeException( Record<?> aDataRecord, String message, Throwable cause ) {
			super( message, cause );
			_dataRecord = aDataRecord;
		}

		/**
		 * Instantiates a new logger record runtime exception.
		 *
		 * @param aDataRecord the data record
		 * @param message the message
		 */
		public LoggerRecordRuntimeException( Record<?> aDataRecord, String message ) {
			super( message );
			_dataRecord = aDataRecord;
		}

		/**
		 * Instantiates a new logger record runtime exception.
		 *
		 * @param aDataRecord the data record
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public LoggerRecordRuntimeException( Record<?> aDataRecord, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_dataRecord = aDataRecord;
		}

		/**
		 * Instantiates a new logger record runtime exception.
		 *
		 * @param aDataRecord the data record
		 * @param cause the cause
		 */
		public LoggerRecordRuntimeException( Record<?> aDataRecord, Throwable cause ) {
			super( cause );
			_dataRecord = aDataRecord;
		}

		// /////////////////////////////////////////////////////////////////////////
		// METHODS:
		/**
		 * Gets the record.
		 *
		 * @return the record
		 */
		// /////////////////////////////////////////////////////////////////////////
		@Override
		public Record<?> getRecord() {
			return _dataRecord;
		}
	}
}
