// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.logger;

import org.refcodes.logger.LoggerRuntimeException.LoggerRecordRuntimeException;
import org.refcodes.tabular.Record;

/**
 * Thrown in case some other problems regarding logging occurred, e.g. the data
 * sink (physical system where to log to) experiences problems.
 */
public class UnexpectedLogRuntimeException extends LoggerRecordRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new unexpected log runtime exception.
	 *
	 * @param aDataRecord the data record
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public UnexpectedLogRuntimeException( Record<?> aDataRecord, String aMessage, String aErrorCode ) {
		super( aDataRecord, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new unexpected log runtime exception.
	 *
	 * @param aDataRecord the data record
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public UnexpectedLogRuntimeException( Record<?> aDataRecord, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aDataRecord, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new unexpected log runtime exception.
	 *
	 * @param aDataRecord the data record
	 * @param message the message
	 * @param cause the cause
	 */
	public UnexpectedLogRuntimeException( Record<?> aDataRecord, String message, Throwable cause ) {
		super( aDataRecord, message, cause );
	}

	/**
	 * Instantiates a new unexpected log runtime exception.
	 *
	 * @param aDataRecord the data record
	 * @param message the message
	 */
	public UnexpectedLogRuntimeException( Record<?> aDataRecord, String message ) {
		super( aDataRecord, message );
	}

	/**
	 * Instantiates a new unexpected log runtime exception.
	 *
	 * @param aDataRecord the data record
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public UnexpectedLogRuntimeException( Record<?> aDataRecord, Throwable aCause, String aErrorCode ) {
		super( aDataRecord, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new unexpected log runtime exception.
	 *
	 * @param aDataRecord the data record
	 * @param cause the cause
	 */
	public UnexpectedLogRuntimeException( Record<?> aDataRecord, Throwable cause ) {
		super( aDataRecord, cause );
	}
}
