// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

/**
 * The "refcodes-logger" artifact provides the refcodes logging framework for
 * flexible logging of any data to any data sink (inclucing files, databases or
 * the console provided as alternate implementations).
 * <p>
 * The "refcodes-logger" artifact supports straight forward, composite
 * (clustering) or partitioning functionality as implementations of the
 * {@link org.refcodes.logger.Logger} type. The "REFCODES.ORG" runtime logger
 * {@link org.refcodes.logger.RuntimeLogger} integrates with "SLF4J" seamlessly
 * and also acts as an alternative to to "SLF4J".
 * <p>
 * The {@link org.refcodes.logger.RuntimeLogger} implementations are being
 * configured with a {@link org.refcodes.logger.Logger} implementation. In your
 * code, you use the {@link org.refcodes.logger.RuntimeLogger} type which,
 * depending on you configuring it, logs to a "SimpleDB" cluster, the console
 * (with "ANSI" escape sequence support) or any I/O device as well as to an
 * "SLF4J" logger.
 * <p>
 * Being an alternative to "SLF4J", the
 * {@link org.refcodes.logger.RuntimeLogger}'s architecture settles upon the
 * much more generic {@link org.refcodes.logger.Logger}; which actually can be
 * used to log high volume logs of any data type and not being restricted to
 * runtime logs. The {@link org.refcodes.logger.RuntimeLogger} implementations
 * add functionality not found in other logging frameworks (logging out the
 * class- and method-names of the logging methods without any configuration or
 * additional lines of code)
 * <h2>Logger:</h2> The {@link org.refcodes.logger.Logger} is the most plain
 * logger definition allowing you to log any kinds of data
 * {@link org.refcodes.tabular.Record}s; being of type
 * {@link org.refcodes.tabular.Record} - and which can contain any number of
 * {@link org.refcodes.tabular.Column}s, so that you are enabled to log big data
 * of any structured information (e.g. high volume HTTP-Requests entering your
 * RESTful microservice).
 * <h2>RuntimeLogger:</h2> The {@link org.refcodes.logger.RuntimeLogger} defines
 * a plain simple interface for logging out runtime information generated by
 * software systems. The {@link org.refcodes.logger.RuntimeLoggerImpl}
 * implementation takes care of logging out the class and the method generating
 * a log line.
 * <p>
 * The {@link org.refcodes.logger.RuntimeLoggerImpl} actually takes a
 * {@link org.refcodes.logger.Logger} instance; which implementation to take is
 * up to you:
 * <ul>
 * <li>SystemLogger</li>
 * <li>AsyncLogger</li>
 * <li>ConsoleLoggerImpl (ConsoleLoggerImpl)</li>
 * <li>IoLoggerImpl</li>
 * <li>SimpleDbLoggerImpl</li>
 * <li>SimpleDbLoggerImpl</li>
 * <li>Slf4jLogger</li>
 * </ul>
 * (you find the various {@link org.refcodes.logger.Logger} implementations in
 * the refcodes-logger-alt artifact's modules)
 * <p>
 * Use the factory (the factory is implemented as a singleton)
 * {@link org.refcodes.logger.RuntimeLoggerFactorySingleton} retrieving
 * {@link org.refcodes.logger.RuntimeLogger} instances configured by a
 * "<code>runtimelogger.ini</code>" file (see
 * "http://www.refcodes.org/refcodes/refcodes-logger"). On how to configure,
 * take a look at it's super-class
 * {@link org.refcodes.logger.RuntimeLoggerFactoryImpl}.
 * <p>
 * A SLF4J binding exists in the refcodes-logger-ext-slf4j" artifact which binds
 * the refcodes-logger framework to SLF4J enabling to log all your SLF4J logs
 * out by the refcodes-logger framework, e.g. to a SimpleDbLoggerImpl.
 * <p>
 * The {@link org.refcodes.logger.RuntimeLogger} may also be configured with one
 * of the below mentioned loggers.
 * <h2>Composite logger:</h2> The
 * {@link org.refcodes.logger.CompositeLoggerImpl} uses the composite patter to
 * forward logger functionality to a number encapsulated logger instances.
 * Depending on the performance (and availability) of an encapsulated logger,
 * the calls to the composite's #log(Record) method are executed by the next
 * encapsulated logger ready for execution.
 * <p>
 * An invocation of the
 * {@link org.refcodes.logger.CompositeLoggerImpl#log(org.refcodes.tabular.Record)}
 * method is forwarded to exactly one of the encapsulated
 * {@link org.refcodes.logger.Logger} instances. The actual instance being
 * called depends on its availability (in case, partitioning is needed, take a
 * look at the {@link org.refcodes.logger.PartedLoggerImpl} and its
 * sub-classes).
 * <p>
 * Using the {@link org.refcodes.logger.CompositeLoggerImpl}, a huge number of
 * {@link org.refcodes.tabular.Record} instances can be logged in parallel by
 * logging them to different physical data sinks (represented by the
 * encapsulated logger instances), thereby avoiding a bottleneck which a single
 * physical data sink would cause for logging.
 * <p>
 * Internally a log line queue (holding {@link org.refcodes.tabular.Record}
 * instances to be logged) as well a daemon thread per encapsulated logger
 * (taking elements from the log line queue) are used to decouple the
 * encapsulated logger instances from the
 * {@link org.refcodes.logger.CompositeLoggerImpl}.
 * <p>
 * A given number of retries are approached in case there is an overflow of the
 * log line queue; this happens when the queue is full and there are none
 * encapsulated logger instances to take the next
 * {@link org.refcodes.tabular.Record}.
 * <p>
 * To avoid a building up of the log line queue, eventually causing an out of
 * memory, log lines not being taken into the log line queue (as it is full)
 * within the given number of retries, them log lines are dismissed. In such a
 * case a warning with a log-level WARN is printed out.
 * <h2>Query logger:</h2> The
 * {@link org.refcodes.logger.CompositeQueryLoggerImpl} extends the
 * {@link org.refcodes.logger.CompositeLoggerImpl} with the query logger
 * functionality. In contrast to the #log(Record) method, which is forwarded to
 * exactly one of the encapsulated query logger instances, the #findLogs()
 * method calls are forwarded to all of the encapsulated query logger instances.
 * (in case, partitioning is needed, take a look at the
 * {@link org.refcodes.logger.PartedQueryLoggerImpl})
 * <h2>Trim logger:</h2> The {@link org.refcodes.logger.CompositeTrimLoggerImpl}
 * extends the {@link org.refcodes.logger.CompositeQueryLoggerImpl} with the
 * trim logger functionality. In contrast to the
 * {@link org.refcodes.logger.CompositeTrimLoggerImpl#log(org.refcodes.tabular.Record)}
 * method, which is forwarded to exactly one of the encapsulated trim logger
 * instances, the
 * {@link org.refcodes.logger.CompositeTrimLoggerImpl#deleteLogs(org.refcodes.criteria.Criteria)}
 * and {@link org.refcodes.logger.CompositeTrimLoggerImpl#clear()} method calls
 * are forwarded to all of the encapsulated
 * {@link org.refcodes.logger.TrimLogger} instances (in case, partitioning is
 * needed, take a look at the {@link org.refcodes.logger.PartedTrimLoggerImpl}).
 * <h2>Parted logger:</h2> The {@link org.refcodes.logger.PartedLoggerImpl} is a
 * partitioning logger which encapsulates {@link org.refcodes.logger.Logger}
 * instances or {@link org.refcodes.logger.CompositeLoggerImpl} instances (or
 * sub-classes of it) representing partitions.
 * <p>
 * This means: A partition is regarded to be a dedicated physical data sink or a
 * {@link org.refcodes.logger.CompositeLoggerImpl} containing
 * {@link org.refcodes.logger.Logger} instances attached to physical data sinks.
 * A physical data sink may be a database (SQL or NoSQL), a files-system or
 * volatile memory (in memory). To be more concrete: A physical data sink may be
 * a domain when using Amazon's SimpleDB, it may be a database table when using
 * MySQL, it may be a HashMap or a List when using in memory storage.
 * <p>
 * The {@link org.refcodes.tabular.Record} instances as managed by the
 * {@link org.refcodes.logger.Logger} instances are mapped to the fields of the
 * physical data sink (e.g. table columns regarding databases).
 * <p>
 * The {@link org.refcodes.tabular.Record} instances are stored to, retrieved
 * from or deleted from dedicated partitions depending on partitioning
 * {@link org.refcodes.criteria.Criteria} contained in the
 * {@link org.refcodes.tabular.Record} instances (or the query
 * {@link org.refcodes.criteria.Criteria} instances). The
 * {@link org.refcodes.criteria.Criteria} (e.g. the column partition
 * {@link org.refcodes.criteria.Criteria} in a
 * {@link org.refcodes.tabular.Record}) as provided to the #log(Record) method
 * is used by the {@link org.refcodes.logger.PartedLoggerImpl} to select the
 * partition to be addressed. In case of query operations the query
 * {@link org.refcodes.criteria.Criteria} is used to determine the targeted
 * partition.
 * <p>
 * (in case no partition can be determined and a fallback logger has been
 * configured, then data may get logged to the fallback logger)
 * <p>
 * In practice there can be several (composite) logger instances being the
 * partitions of the {@link org.refcodes.logger.PartedLoggerImpl}, each
 * individually addressed by the partitioning
 * {@link org.refcodes.criteria.Criteria}.
 * <p>
 * This approach a) helps us scale horizontally per partition when using
 * {@link org.refcodes.logger.CompositeLoggerImpl} instances per partition and
 * b) helps limiting the traffic on those horizontally scaling (composite)
 * logger instances by partitioning the data per
 * {@link org.refcodes.criteria.Criteria} using the parted logger (or its
 * sub-classes): Partitioning simply means switching to the partition defined by
 * the {@link org.refcodes.criteria.Criteria} to perform the according logger
 * operation.
 * <p>
 * Not having the {@link org.refcodes.logger.PartedLoggerImpl} (or a sub-class
 * of it) would cause all the traffic for all
 * {@link org.refcodes.criteria.Criteria} to hit just a single (composite)
 * {@link org.refcodes.logger.Logger}, limiting the possibility to scale
 * endlessly (this one logger would be the bottleneck, even when being massively
 * scaled horizontally): In particular this applies when looking at the extended
 * versions of the {@link org.refcodes.logger.PartedLoggerImpl} such as the
 * {@link org.refcodes.logger.PartedQueryLoggerImpl} and the
 * {@link org.refcodes.logger.PartedTrimLoggerImpl} where query requests are
 * passed only to the partition which contains the required data: Increasing
 * query traffic is parted and does not hit increasingly a single (composite)
 * logger.
 * <p>
 * A {@link org.refcodes.tabular.Record} to be assigned to a partition must
 * provide a column, the so called partition column, whose value is used to
 * determine which partition is to be addressed. The partition identifying
 * column is passed upon construction to this
 * {@link org.refcodes.logger.PartedLoggerImpl}. Specializations may hide this
 * parameter from their constructors and pass their partitioning column from
 * inside their constructor to the super constructor.
 * <p>
 * The {@link org.refcodes.logger.PartedQueryLoggerImpl} extends the
 * {@link org.refcodes.logger.PartedLoggerImpl} with the functionality of a
 * query logger. Any query operations, such as #findLogs(Criteria), are targeted
 * at that partition containing the queried data. For this to work, the query
 * must obey some rules:
 * <p>
 * The query is to contain an {@link org.refcodes.criteria.EqualWithCriteria}
 * addressing the partition in an unambiguous way; by being part of a root level
 * {@link org.refcodes.criteria.AndCriteria} or an unambiguously nested
 * {@link org.refcodes.criteria.AndCriteria} hierarchy. More than one partition
 * gets detected when unambiguous {@link org.refcodes.criteria.OrCriteria} are
 * applied to the partition criteria. In such cases, the query is addressed to
 * the potential partitions.
 * <p>
 * In case it was not possible to identify any partitions, then as a fallback,
 * all partitions are queried.
 * <p>
 * Query results are taken from from the invoked partitions (in normal cases
 * this would be a single partition) round robin. the first result is taken from
 * the first queried partition's result set (
 * {@link org.refcodes.tabular.Record} s), the next result from the next queried
 * partition and so on to start over again with the first queried partition.
 * Round robin has been used to prevent invalidation of physical data sinks's
 * result sets as of timeouts.
 * <p>
 * The {@link org.refcodes.logger.PartedTrimLoggerImpl} extends the parted query
 * logger with the functionality of a trim logger. Delete operations with a
 * query such as #deleteLogs(Criteria) are applied to the partitions in the same
 * manner as done for #findLogs(Criteria).
 * <ul>
 * <li><code>org.refcodes.logger.AbstractCompositeLogger</code></li>
 * <li><code>org.refcodes.logger.AbstractCompositeQueryLogger</code></li>
 * <li><code>org.refcodes.logger.AbstractCompositeTrimLogger</code></li>
 * <li><code>org.refcodes.logger.CompositeLoggerImpl</code></li>
 * <li><code>org.refcodes.logger.CompositeQueryLoggerImpl</code></li>
 * <li><code>org.refcodes.logger.CompositeTrimLoggerImpl</code></li>
 * <li><code>org.refcodes.logger.CompositeLoggerFactoryImpl</code></li>
 * <li><code>org.refcodes.logger.CompositeQueryLoggerFactoryImpl</code></li>
 * <li><code>org.refcodes.logger.CompositeTrimLoggerFactoryImpl</code></li>
 * <li><code>org.refcodes.logger.AbstractPartedLogger</code></li>
 * <li><code>org.refcodes.logger.AbstractPartedQueryLogger</code></li>
 * <li><code>org.refcodes.logger.AbstractPartedTrimLogger</code></li>
 * <li><code>org.refcodes.logger.PartedLoggerImpl</code></li>
 * <li><code>org.refcodes.logger.PartedQueryLoggerImpl</code></li>
 * <li><code>org.refcodes.logger.PartedTrimLoggerImpl</code></li>
 * </ul>
 */
package org.refcodes.logger;
