/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.refcodes.component.ComponentUtility;
import org.refcodes.component.Decomposable;
import org.refcodes.component.InitializeException;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.Logger;
import org.refcodes.logger.LoggerFactory;
import org.refcodes.logger.UnexpectedLogRuntimeException;
import org.refcodes.mixin.UniversalIdAccessor;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.TabularUtility;
import org.refcodes.textual.VerboseTextBuilder;

abstract class AbstractPartedLogger<L extends Logger<T>, T, P extends T>
implements Logger<T> {
    private static java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(AbstractPartedLogger.class.getName());
    private Column<P> _partitionColumn;
    private boolean _isPartitionAutoInitialize;
    private LoggerFactory<L> _loggerFactory;
    private Map<P, L> _partitionToLoggerMap = new HashMap<P, L>();
    private L _fallBackLogger;

    public AbstractPartedLogger(Column<P> aPartitionColumn, LoggerFactory<L> aLoggerFactory, boolean isPartitionAutoInitialize) {
        this(aPartitionColumn, null, aLoggerFactory, isPartitionAutoInitialize);
    }

    public AbstractPartedLogger(Column<P> aPartitionColumn, String aDefaultLoggerName, LoggerFactory<L> aLoggerFactory, boolean isPartitionAutoInitialize) {
        this._loggerFactory = aLoggerFactory;
        this._partitionColumn = aPartitionColumn;
        this._isPartitionAutoInitialize = isPartitionAutoInitialize;
        if (aDefaultLoggerName != null && aDefaultLoggerName.length() > 0) {
            this._fallBackLogger = (Logger)this._loggerFactory.create(aDefaultLoggerName);
        }
        LOGGER.log(Level.FINE, "Using a partition column for type <" + aPartitionColumn.getType().getName() + "> with key \"" + (String)aPartitionColumn.getKey() + "\".");
    }

    @Override
    public void log(Record<? extends T> aRecord) throws IllegalRecordRuntimeException, UnexpectedLogRuntimeException {
        try {
            L theLogger = this.getPartitionLogger((P)aRecord);
            theLogger.log(aRecord);
        }
        catch (ColumnMismatchException e) {
            throw new IllegalRecordRuntimeException(aRecord, "Unable to retrieve partition column value from record!", e);
        }
    }

    public boolean hasPartition(P aPartition) {
        return this._partitionToLoggerMap.containsKey(aPartition);
    }

    public synchronized L initPartition(P aPartition) throws InitializeException {
        String thePartitionIdentifier = this.getPartitionUid(aPartition);
        LOGGER.log(Level.FINE, "Initializing the partition \"" + (aPartition == null ? "(null)" : thePartitionIdentifier) + "\" ...");
        if (this._partitionToLoggerMap.containsKey(aPartition)) {
            throw new InitializeException("A partition \"" + thePartitionIdentifier + "\" has already been initialized for column with key \"" + (String)this._partitionColumn.getKey() + "\" (with type \"" + this._partitionColumn.getType().getName() + "\").");
        }
        Logger theLogger = (Logger)this._loggerFactory.create(thePartitionIdentifier);
        ComponentUtility.initialize((Object)theLogger);
        this._partitionToLoggerMap.put(aPartition, theLogger);
        return (L)theLogger;
    }

    public synchronized void destroyPartition(P aPartition) {
        Logger theLogger = (Logger)this._partitionToLoggerMap.remove(aPartition);
        if (theLogger == null) {
            return;
        }
        ComponentUtility.destroy((Object)theLogger);
    }

    public void flushPartition(P aPartition) throws IOException {
        Logger theLogger = (Logger)this._partitionToLoggerMap.get(aPartition);
        if (theLogger == null) {
            throw new IOException("A partition \"" + this.getPartitionUid(aPartition) + "\" was not found for column with key \"" + (String)this._partitionColumn.getKey() + "\" (and type \"" + this._partitionColumn.getType().getName() + "\").");
        }
        ComponentUtility.flush((Object)theLogger);
    }

    public void decomposePartition(P aPartition) {
        Logger theLogger = (Logger)this._partitionToLoggerMap.remove(aPartition);
        if (theLogger == null) {
            return;
        }
        if (theLogger instanceof Decomposable) {
            ((Decomposable)theLogger).decompose();
        }
    }

    protected Collection<L> getLoggers() {
        Collection<L> result = this._partitionToLoggerMap.values();
        if (this._fallBackLogger != null) {
            result.add(this._fallBackLogger);
        }
        return this._partitionToLoggerMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private L getPartitionLogger(Record<?> aRecord) throws ColumnMismatchException, UnexpectedLogRuntimeException, IllegalRecordRuntimeException {
        P thePartition = this.getPartition(aRecord);
        Object theLogger = thePartition == null && this._fallBackLogger != null ? this._fallBackLogger : (Logger)this._partitionToLoggerMap.get(thePartition);
        if (theLogger == null) {
            if (this._isPartitionAutoInitialize) {
                AbstractPartedLogger abstractPartedLogger = this;
                synchronized (abstractPartedLogger) {
                    theLogger = (Logger)this._partitionToLoggerMap.get(thePartition);
                    if (theLogger != null) {
                        return theLogger;
                    }
                    try {
                        theLogger = this.initPartition(thePartition);
                    }
                    catch (InitializeException e) {
                        throw new UnexpectedLogRuntimeException(aRecord, "Unable to initialize partition \"" + thePartition + "\" of record { " + TabularUtility.toSeparatedValues(aRecord, (char)',') + " } !", e);
                    }
                }
            }
            throw new IllegalRecordRuntimeException(aRecord, "Unable to retrieve partition \"" + thePartition + "\" (auto create for partitions is diabled), perform the operation!");
        }
        return theLogger;
    }

    private P getPartition(Record<?> aRecord) throws ColumnMismatchException, IllegalRecordRuntimeException {
        Object theObj = this._partitionColumn.get(aRecord);
        if (theObj == null && this._fallBackLogger == null) {
            LOGGER.log(Level.WARNING, "An erronous record was provided: " + new VerboseTextBuilder().withElements(aRecord).toString());
            throw new IllegalRecordRuntimeException(aRecord, "The record does not contain a partition column \"" + (String)this._partitionColumn.getKey() + "\" (\"" + (String)this._partitionColumn.getKey() + "\"), therefore no partition can be determined!");
        }
        if (theObj == null) {
            LOGGER.log(Level.FINE, "The partition column ('" + (String)this._partitionColumn.getKey() + "') not located in provided record, 'null' value returned.");
            return null;
        }
        LOGGER.log(Level.FINE, "Retrieved a partition of type <" + theObj.getClass().getName() + "> (\"" + theObj.toString() + "\") which is to be challenged with the type <" + this._partitionColumn.getType().getName() + "> ...");
        Object thePartition = null;
        if (this._partitionColumn.getType().isAssignableFrom(theObj.getClass())) {
            thePartition = theObj;
        }
        LOGGER.log(Level.FINE, "Determined the partition \"" + (thePartition == null ? "(null)" : this.getPartitionUid(thePartition)) + "\" for record the priovided record.");
        return (P)thePartition;
    }

    protected String getPartitionUid(P aPartition) {
        String thePartition = null;
        if (aPartition != null) {
            thePartition = aPartition instanceof UniversalIdAccessor ? ((UniversalIdAccessor)aPartition).getUniversalId() : aPartition.toString();
        }
        return thePartition;
    }

    protected Column<P> getPartitionColumn() {
        return this._partitionColumn;
    }

    protected L getPartitionLogger(P aPartition) {
        return (L)((Logger)this._partitionToLoggerMap.get(aPartition));
    }

    protected L getFallbackLogger() {
        return this._fallBackLogger;
    }
}

