/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import org.refcodes.controlflow.InvocationStrategy;
import org.refcodes.criteria.Criteria;
import org.refcodes.criteria.CriteriaException;
import org.refcodes.exception.BugException;
import org.refcodes.logger.AbstractLoggerComposite;
import org.refcodes.logger.LoggerUtility;
import org.refcodes.logger.QueryLogger;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.Records;

abstract class AbstractQueryLoggerComposite<L extends QueryLogger<T>, T>
extends AbstractLoggerComposite<L, T>
implements QueryLogger<T> {
    @SafeVarargs
    public AbstractQueryLoggerComposite(L ... aLoggers) {
        super(aLoggers);
    }

    @Override
    public Records<T> findLogs() {
        try {
            return this.findLogs(null, null, -1);
        }
        catch (CriteriaException.BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + ((Object)((Object)e)).getClass().getName() + "> as no criteria has been provided: ", (Throwable)e);
        }
    }

    @Override
    public Records<T> findLogs(int aLimit) {
        try {
            return this.findLogs(null, null, aLimit);
        }
        catch (CriteriaException.BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + ((Object)((Object)e)).getClass().getName() + "> as no criteria has been provided: ", (Throwable)e);
        }
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria) {
        try {
            return this.findLogs(aCriteria, null, -1);
        }
        catch (CriteriaException.BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + ((Object)((Object)e)).getClass().getName() + "> as no criteria has been provided: ", (Throwable)e);
        }
    }

    @Override
    public Records<T> findLogs(Header<T> aHeader, int aLimit) {
        try {
            return this.findLogs(null, aHeader, aLimit);
        }
        catch (CriteriaException.BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + ((Object)((Object)e)).getClass().getName() + "> as no criteria has been provided: ", (Throwable)e);
        }
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria, int aLimit) throws CriteriaException.BadCriteriaException {
        return this.findLogs(aCriteria, null, aLimit);
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria, Header<T> aHeader) throws CriteriaException.BadCriteriaException {
        return this.findLogs(aCriteria, aHeader, -1);
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria, Header<T> aHeader, int aLimit) throws CriteriaException.BadCriteriaException {
        return LoggerUtility.findLogs(aCriteria, aHeader, aLimit, this.getLoggers(), InvocationStrategy.ROUND_ROBIN);
    }
}

