/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.logging.Level;

public enum LogPriority {
    PANIC(8),
    ALERT(7),
    CRITICAL(6),
    ERROR(5),
    WARN(4),
    NOTICE(3),
    INFO(2),
    DEBUG(1),
    TRACE(0),
    DISCARD(-1),
    NONE(-2);

    private int _priority;

    private LogPriority(int aPriority) {
        this._priority = aPriority;
    }

    public int getPriority() {
        return this._priority;
    }

    public String getLogLevel() {
        return this.name();
    }

    public static LogPriority toProprtiry(String aPriorityName) {
        for (LogPriority ePriority : LogPriority.values()) {
            if (!ePriority.name().equalsIgnoreCase(aPriorityName)) continue;
            return ePriority;
        }
        return null;
    }

    public static LogPriority fromLevel(Level aLevel) {
        if (Level.OFF.equals(aLevel)) {
            return NONE;
        }
        if (Level.SEVERE.equals(aLevel)) {
            return ERROR;
        }
        if (Level.WARNING.equals(aLevel)) {
            return WARN;
        }
        if (Level.CONFIG.equals(aLevel)) {
            return NOTICE;
        }
        if (Level.INFO.equals(aLevel)) {
            return INFO;
        }
        if (Level.FINE.equals(aLevel)) {
            return DEBUG;
        }
        if (Level.FINER.equals(aLevel)) {
            return DEBUG;
        }
        if (Level.FINEST.equals(aLevel)) {
            return TRACE;
        }
        if (Level.ALL.equals(aLevel)) {
            return TRACE;
        }
        return INFO;
    }

    public Level toLevel() {
        switch (this) {
            case PANIC: {
                return Level.SEVERE;
            }
            case ALERT: {
                return Level.SEVERE;
            }
            case CRITICAL: {
                return Level.SEVERE;
            }
            case ERROR: {
                return Level.SEVERE;
            }
            case WARN: {
                return Level.WARNING;
            }
            case NOTICE: {
                return Level.CONFIG;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case TRACE: {
                return Level.FINEST;
            }
            case DISCARD: {
                return Level.OFF;
            }
            case NONE: {
                return Level.OFF;
            }
        }
        return Level.INFO;
    }
}

