/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.refcodes.logger.LogPriority;
import org.refcodes.logger.LogPriorityAccessor;
import org.refcodes.logger.Logger;
import org.refcodes.logger.LoggerAccessor;
import org.refcodes.logger.LoggerField;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.SystemLogger;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.runtime.Correlation;
import org.refcodes.runtime.Execution;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.RecordImpl;
import org.refcodes.textual.MessageBuilder;

public class RuntimeLoggerImpl
implements RuntimeLogger,
LoggerAccessor.LoggerProperty<Logger<Object>>,
NameAccessor.NameProperty,
LogPriorityAccessor.LogPriorityProperty {
    public static final String ROOT_LOGGER_NAME = "*";
    public static final LogPriority DEFAULT_LOG_PRIORITY = LogPriority.INFO;
    private String _name;
    private Logger<Object> _logger;
    private LogPriority _logPriority;
    static AtomicInteger _lineNumber = new AtomicInteger(1);

    public RuntimeLoggerImpl(String aName, Logger<Object> aLogger, LogPriority aPriority) {
        this._logger = aLogger;
        this._logPriority = aPriority;
        this._name = aName;
        if (aLogger instanceof NameAccessor.NameMutator) {
            ((NameAccessor.NameMutator)aLogger).setName(aName);
        }
    }

    public RuntimeLoggerImpl(String aName, Logger<Object> aLogger) {
        this(aName, aLogger, DEFAULT_LOG_PRIORITY);
    }

    public RuntimeLoggerImpl(Logger<Object> aLogger, LogPriority aPriority) {
        this(ROOT_LOGGER_NAME, aLogger, aPriority);
    }

    public RuntimeLoggerImpl(Logger<Object> aLogger) {
        this(ROOT_LOGGER_NAME, aLogger, DEFAULT_LOG_PRIORITY);
    }

    public RuntimeLoggerImpl() {
        this(ROOT_LOGGER_NAME, new SystemLogger(), DEFAULT_LOG_PRIORITY);
    }

    @Override
    public void log(LogPriority aPriority, String aMessage) {
        if (aPriority != LogPriority.DISCARD && this._logPriority != LogPriority.DISCARD && this.isLog(aPriority)) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(aPriority, aMessage, theStackTraceElement, null);
        }
    }

    @Override
    public void log(LogPriority aPriority, String aMessage, Throwable aThrowable) {
        if (aPriority != LogPriority.DISCARD && this._logPriority != LogPriority.DISCARD && this.isLog(aPriority)) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(aPriority, aMessage, theStackTraceElement, aThrowable);
        }
    }

    @Override
    public boolean isLog(LogPriority aPriority) {
        return aPriority.getPriority() >= this._logPriority.getPriority();
    }

    @Override
    public LogPriority getLogPriority() {
        return this._logPriority;
    }

    @Override
    public void trace(String aMessage) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogTrace()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.TRACE, aMessage, theStackTraceElement, null);
        }
    }

    @Override
    public boolean isLogTrace() {
        return LogPriority.TRACE.getPriority() >= this._logPriority.getPriority();
    }

    @Override
    public void debug(String aMessage) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogDebug()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.DEBUG, aMessage, theStackTraceElement, null);
        }
    }

    @Override
    public boolean isLogDebug() {
        return LogPriority.DEBUG.getPriority() >= this._logPriority.getPriority();
    }

    @Override
    public void info(String aMessage) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogInfo()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.INFO, aMessage, theStackTraceElement, null);
        }
    }

    @Override
    public boolean isLogInfo() {
        return LogPriority.INFO.getPriority() >= this._logPriority.getPriority();
    }

    @Override
    public void notice(String aMessage) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogNotice()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.NOTICE, aMessage, theStackTraceElement, null);
        }
    }

    @Override
    public boolean isLogNotice() {
        return LogPriority.NOTICE.getPriority() >= this._logPriority.getPriority();
    }

    @Override
    public void warn(String aMessage) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogWarn()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.WARN, aMessage, theStackTraceElement, null);
        }
    }

    @Override
    public void warn(String aMessage, Throwable aThrowable) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogWarn()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.WARN, aMessage, theStackTraceElement, aThrowable);
        }
    }

    @Override
    public boolean isLogWarn() {
        return LogPriority.WARN.getPriority() >= this._logPriority.getPriority();
    }

    @Override
    public void error(String aMessage) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogError()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.ERROR, aMessage, theStackTraceElement, null);
        }
    }

    @Override
    public void error(String aMessage, Throwable aThrowable) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogError()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.ERROR, aMessage, theStackTraceElement, aThrowable);
        }
    }

    @Override
    public boolean isLogError() {
        return LogPriority.ERROR.getPriority() >= this._logPriority.getPriority();
    }

    @Override
    public void critical(String aMessage) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogCritical()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.CRITICAL, aMessage, theStackTraceElement, null);
        }
    }

    @Override
    public void critical(String aMessage, Throwable aThrowable) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogCritical()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.CRITICAL, aMessage, theStackTraceElement, aThrowable);
        }
    }

    @Override
    public boolean isLogCritical() {
        return LogPriority.CRITICAL.getPriority() >= this._logPriority.getPriority();
    }

    @Override
    public void alert(String aMessage) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogAlert()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.ALERT, aMessage, theStackTraceElement, null);
        }
    }

    @Override
    public void alert(String aMessage, Throwable aThrowable) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogAlert()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.ALERT, aMessage, theStackTraceElement, aThrowable);
        }
    }

    @Override
    public boolean isLogAlert() {
        return LogPriority.ALERT.getPriority() >= this._logPriority.getPriority();
    }

    @Override
    public void panic(String aMessage) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogPanic()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.PANIC, aMessage, theStackTraceElement, null);
        }
    }

    @Override
    public void panic(String aMessage, Throwable aThrowable) {
        if (this._logPriority != LogPriority.DISCARD && this.isLogPanic()) {
            StackTraceElement theStackTraceElement = RuntimeLoggerImpl.getCallerStackTraceElement();
            this.doLog(LogPriority.PANIC, aMessage, theStackTraceElement, aThrowable);
        }
    }

    @Override
    public boolean isLogPanic() {
        return LogPriority.PANIC.getPriority() >= this._logPriority.getPriority();
    }

    @Override
    public void log(LogPriority aPriority, String aMessage, Object ... aArguments) {
        if (this.isLog(aPriority)) {
            this.log(aPriority, MessageBuilder.asMessage((String)aMessage, (Object[])aArguments));
        }
    }

    @Override
    public void log(LogPriority aPriority, String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this.isLog(aPriority)) {
            this.log(aPriority, MessageBuilder.asMessage((String)aMessage, (Object[])aArguments), aThrowable);
        }
    }

    @Override
    public void trace(String aMessage, Object ... aArguments) {
        if (this.isLogTrace()) {
            this.trace(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments));
        }
    }

    @Override
    public void debug(String aMessage, Object ... aArguments) {
        if (this.isLogDebug()) {
            this.debug(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments));
        }
    }

    @Override
    public void info(String aMessage, Object ... aArguments) {
        if (this.isLogInfo()) {
            this.info(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments));
        }
    }

    @Override
    public void notice(String aMessage, Object ... aArguments) {
        if (this.isLogNotice()) {
            this.notice(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments));
        }
    }

    @Override
    public void warn(String aMessage, Object ... aArguments) {
        if (this.isLogWarn()) {
            this.warn(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments));
        }
    }

    @Override
    public void warn(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this.isLogWarn()) {
            this.warn(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments), aThrowable);
        }
    }

    @Override
    public void error(String aMessage, Object ... aArguments) {
        if (this.isLogError()) {
            this.error(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments));
        }
    }

    @Override
    public void error(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this.isLogError()) {
            this.error(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments), aThrowable);
        }
    }

    @Override
    public void critical(String aMessage, Object ... aArguments) {
        if (this.isLogCritical()) {
            this.critical(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments));
        }
    }

    @Override
    public void critical(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this.isLogCritical()) {
            this.critical(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments), aThrowable);
        }
    }

    @Override
    public void alert(String aMessage, Object ... aArguments) {
        if (this.isLogAlert()) {
            this.alert(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments));
        }
    }

    @Override
    public void alert(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this.isLogAlert()) {
            this.alert(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments), aThrowable);
        }
    }

    @Override
    public void panic(String aMessage, Object ... aArguments) {
        if (this.isLogPanic()) {
            this.panic(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments));
        }
    }

    @Override
    public void panic(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this.isLogPanic()) {
            this.panic(MessageBuilder.asMessage((String)aMessage, (Object[])aArguments), aThrowable);
        }
    }

    @Override
    public void setLogger(Logger<Object> aLogger) {
        this._logger = aLogger;
    }

    public void setLogLevel(String aLogLevel) {
        this.setLogPriority(LogPriority.valueOf(aLogLevel));
    }

    @Override
    public void setLogPriority(LogPriority aLogPriority) {
        Execution.setJulLoggingLevel((Level)aLogPriority.toLevel());
        this._logPriority = aLogPriority;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String aName) {
        this._name = aName;
        Logger<Object> theLogger = this._logger;
        if (theLogger instanceof NameAccessor.NameMutator) {
            ((NameAccessor.NameMutator)theLogger).setName(aName);
        }
    }

    @Override
    public void printHead() {
        this._logger.printHead();
    }

    @Override
    public void printSeparator() {
        this._logger.printSeparator();
    }

    @Override
    public void printTail() {
        this._logger.printTail();
    }

    @Override
    public Logger<Object> getLogger() {
        return this._logger;
    }

    protected void doLog(LogPriority aPriority, String aMessage, StackTraceElement aStackTraceElement, Throwable aThrowable) {
        RecordImpl theRecord = new RecordImpl();
        theRecord.put((Object)LoggerField.LOG_LINE_NUMBER.getKey(), (Object)_lineNumber.getAndIncrement());
        theRecord.put((Object)LoggerField.LOG_DATE.getKey(), (Object)new Date());
        theRecord.put((Object)LoggerField.LOG_PRIORITY.getKey(), (Object)aPriority);
        theRecord.put((Object)LoggerField.LOG_THREAD_NAME.getKey(), (Object)Thread.currentThread().getName());
        theRecord.put((Object)LoggerField.LOG_SESSION_ID.getKey(), (Object)Correlation.SESSION.getId());
        theRecord.put((Object)LoggerField.LOG_REQUEST_ID.getKey(), (Object)Correlation.REQUEST.getId());
        theRecord.put((Object)LoggerField.LOG_FULLY_QUALIFIED_CLASS_NAME.getKey(), (Object)Execution.toFullyQualifiedClassName((StackTraceElement)aStackTraceElement));
        theRecord.put((Object)LoggerField.LOG_CLASS_LINE_NUMBER.getKey(), (Object)aStackTraceElement.getLineNumber());
        theRecord.put((Object)LoggerField.LOG_METHODE_NAME.getKey(), (Object)Execution.toMethodName((StackTraceElement)aStackTraceElement));
        theRecord.put((Object)LoggerField.LOG_MESSAGE.getKey(), (Object)aMessage);
        theRecord.put((Object)LoggerField.LOG_EXPLODED_STACKTRACE_EXCEPTION.getKey(), (Object)aThrowable);
        this._logger.log((Record<Object>)theRecord);
    }

    public static StackTraceElement getCallerStackTraceElement() {
        StackTraceElement[] theStackTraceElements;
        for (StackTraceElement eStackTraceElement : theStackTraceElements = Thread.currentThread().getStackTrace()) {
            if (RuntimeLoggerImpl.isSkipStackTraceElement(eStackTraceElement)) continue;
            return eStackTraceElement;
        }
        return theStackTraceElements[theStackTraceElements.length - 1];
    }

    private static boolean isSkipStackTraceElement(StackTraceElement eStackTraceElement) {
        String eClassName = eStackTraceElement.getClassName();
        String eMethodName = eStackTraceElement.getMethodName();
        return !eClassName.endsWith("Test") && !eClassName.endsWith("IT") && (eClassName.equals(Thread.class.getName()) || eClassName.equals(RuntimeLoggerImpl.class.getName()) || eClassName.contains("logger") || eClassName.contains("logging") || eClassName.contains("slf4j") || eClassName.contains("logback") || eClassName.startsWith("java.lang.reflect.") || eClassName.startsWith("sun.reflect.") || eClassName.contains(".log.") || "log".equals(eMethodName) || "invoke".equals(eMethodName) || "invoke0".equals(eMethodName) || "invoke1".equals(eMethodName) || "invoke2".equals(eMethodName) || "invoke3".equals(eMethodName) || "invoke4".equals(eMethodName) || "invoke5".equals(eMethodName));
    }
}

