// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.matcher.impls;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.refcodes.matcher.MatcherDeclaration.equalWith;
import static org.refcodes.matcher.MatcherDeclaration.isAssignableFrom;
import static org.refcodes.matcher.MatcherDeclaration.not;

import org.junit.Test;
import org.refcodes.matcher.Matcher;

public class MatcherTest {

	@Test
	public void testIsType() throws Exception {
		Matcher<Class1> theTypeMatcher = isAssignableFrom( Class1.class );
		assertTrue( theTypeMatcher.isMatching( new Class1() ) );
		assertTrue( theTypeMatcher.isMatching( new Class2() ) );
		assertTrue( theTypeMatcher.isMatching( new Class3() ) );
	}

	@Test
	public void testEquals() throws Exception {
		Matcher<String> theStringMatcher = equalWith( "Test" );
		assertTrue( theStringMatcher.isMatching( "Test" ) );
		assertFalse( theStringMatcher.isMatching( "Hallo" ) );
		assertFalse( theStringMatcher.isMatching( "Foo" ) );

		Matcher<String> theNotMatcher = not( theStringMatcher );
		assertFalse( theNotMatcher.isMatching( "Test" ) );
		assertTrue( theNotMatcher.isMatching( "Hallo" ) );
		assertTrue( theNotMatcher.isMatching( "Foo" ) );
	}

	private class Class1 {}

	private class Class2 extends Class1 {}

	private class Class3 extends Class2 {}
}
