// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.matcher.impls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.refcodes.matcher.WildcardSubstitutes;

/**
 * @author steiner
 *
 */
public class WildcardSubstitutesImpl implements WildcardSubstitutes {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String[] _wildcardSubstitutes;
	private Map<String, String> _namedWildcardSubstittutes;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public WildcardSubstitutesImpl( String[] aWildcardSubstitutes, Map<String, String> aNamedWildcardSubstittutes ) {
		_wildcardSubstitutes = aWildcardSubstitutes;
		_namedWildcardSubstittutes = aNamedWildcardSubstittutes;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public String[] getWildcardReplacements() {
		return _wildcardSubstitutes;
	}

	@Override
	public String getWildcardReplacementAt( int aIndex ) {
		if ( _wildcardSubstitutes != null ) {
			if ( _wildcardSubstitutes.length > aIndex ) { return _wildcardSubstitutes[aIndex]; }
		}
		return null;
	}

	@Override
	public String getWildcardReplacement( String aWildcardName ) {
		if ( _namedWildcardSubstittutes != null ) { return _namedWildcardSubstittutes.get( aWildcardName ); }
		return null;
	}

	@Override
	public String[] getWildcardReplacements( String... aWildcardNames ) {
		List<String> theWildcardSubstitutes = new ArrayList<>();
		String eSubstitute;
		for ( String eName : aWildcardNames ) {
			eSubstitute = getWildcardReplacement( eName );
			if ( eSubstitute == null ) { throw new IllegalArgumentException( "There is none such named wildcard substitute for name <" + eName + ">, check your pattern!." ); }
			theWildcardSubstitutes.add( eSubstitute );
		}
		return theWildcardSubstitutes.toArray( new String[theWildcardSubstitutes.size()] );
	}

	@Override
	public String[] getWildcardReplacementsAt( int... aIndexes ) {
		List<String> theWildcardSubstitutes = new ArrayList<>();
		for ( int i : aIndexes ) {
			if ( i >= _wildcardSubstitutes.length ) { throw new IllegalArgumentException( "Your provided index <" + i + "> exceeds the number of wildcards <" + _wildcardSubstitutes.length + "> defined in your pattern." ); }
			theWildcardSubstitutes.add( _wildcardSubstitutes[i] );
		}
		return theWildcardSubstitutes.toArray( new String[theWildcardSubstitutes.size()] );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
