// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.matcher.impls;

import org.refcodes.matcher.Matcher;

/**
 * A IS ASSIGNABLE FROM implementation of a {@link Matcher} by type.
 *
 * @param <M> The matchee type
 */
public class IsAssignableFromMatcherImpl<M> implements Matcher<M> {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private Class<?> _matcheeType;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs a IS ASSIGNABLE FROM {@link Matcher} using the type of the
	 * matchees being the criteria to determine a match.
	 * 
	 * @param aMatcheeType The type of the matchee to match.
	 */
	public IsAssignableFromMatcherImpl( Class<?> aMatcheeType ) {
		_matcheeType = aMatcheeType;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public boolean isMatching( M aMatchee ) {
		assert (aMatchee != null);
		if ( _matcheeType != null ) {
			if ( !_matcheeType.isAssignableFrom( aMatchee.getClass() ) ) {
				return false;
			}
		}
		return true;
	}
}