/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.matcher;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Delimiter;
import org.refcodes.matcher.PathMatcherImpl;

public class PathMatcherTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static String TEST_CASE = "/foo/acme/atari/bar";
    private static final PatternMatchCase[] TEST_CASES = new PatternMatchCase[]{new PatternMatchCase("/foo/acme/atari/bar", true, null), new PatternMatchCase("/foo/acme/atari/b??", true, null), new PatternMatchCase("/foo/acme/atari/?bar", false, null), new PatternMatchCase("/foo/acme/atar?/?ar", true, null), new PatternMatchCase("/foo/acme/atari/*", true, null), new PatternMatchCase("/foo/acme/schneider/*", false, null), new PatternMatchCase("/foo/acme/**schneider/*", false, null), new PatternMatchCase("/foo/acme/**", true, null), new PatternMatchCase("/foo/acme/*/bar", true, null), new PatternMatchCase("/foo/*/atari/bar", true, null), new PatternMatchCase("/*/acme/atari/bar", true, null), new PatternMatchCase("**/foo/acme/atari/bar", true, null), new PatternMatchCase("**foo/acme/atari/bar", true, null), new PatternMatchCase("*/foo/acme/atari/bar", true, null), new PatternMatchCase("**/bar", true, null), new PatternMatchCase("/*/*/bar", false, null), new PatternMatchCase("**/*/*/bar", true, null), new PatternMatchCase("/**/*/*/bar", true, null), new PatternMatchCase("/*/*/*/bar", true, null), new PatternMatchCase("/foo/*/*/bar", true, null), new PatternMatchCase("/foo/*/bar", false, null), new PatternMatchCase("/foo/**/bar", true, null), new PatternMatchCase("/foo/*/**/bar", true, null), new PatternMatchCase("/foo/a*/*/bar", true, null), new PatternMatchCase("/foo/a*/**/bar", true, null), new PatternMatchCase("/foo/b*/*/bar", false, null), new PatternMatchCase("/foo/b*/**/bar", false, null), new PatternMatchCase("/foo/acme/atari/*", true, null), new PatternMatchCase("/foo/acme/atari/**", true, null), new PatternMatchCase("/foo/acme/atari*/*", true, null), new PatternMatchCase("/foo/acme/sinclair/*", false, null), new PatternMatchCase("/foo/**/bar", true, null), new PatternMatchCase("/foo/**/*b*ar", true, null), new PatternMatchCase("/foo/**/*b**ar", true, null), new PatternMatchCase("/foo/**/*c*ar", false, null), new PatternMatchCase("/foo/acme/atari/bar/*", false, null), new PatternMatchCase("/foo/acme/atari/bar/**", false, null), new PatternMatchCase("/foo/${arg1}/atari/bar", true, new String[]{"arg1"}), new PatternMatchCase("/foo/${arg1}=*/atari/bar", true, new String[]{"arg1"}), new PatternMatchCase("/foo/acme/atari/b${arg1}=??", true, new String[]{"arg1"}), new PatternMatchCase("/foo/acme/atari/${arg1}=?bar", false, null), new PatternMatchCase("/foo/acme/atar${arg1}=?/${arg2}=?ar", true, new String[]{"arg1", "arg2"}), new PatternMatchCase("/foo/acme/atari/${arg1}=*", true, new String[]{"arg1"}), new PatternMatchCase("/foo/acme/schneider/${arg1}=*", false, null), new PatternMatchCase("/foo/acme/${arg1}=**schneider/${arg2}=*", false, null)};

    @Test
    public void testPathMatcher() {
        int i = 0;
        for (PatternMatchCase eCase : TEST_CASES) {
            if (IS_LOG_TESTS) {
                System.out.println("[" + i + "] " + eCase.isMatch() + ": Testing <" + TEST_CASE + "> against <" + eCase.getPattern() + "> to be <" + eCase.isMatch() + "> ...");
            }
            PathMatcherImpl eMatcher = new PathMatcherImpl(eCase.getPattern());
            Assertions.assertEquals((Object)eCase.isMatch(), (Object)eMatcher.isMatching(TEST_CASE));
            ++i;
        }
    }

    @Test
    public void testPathMatcherWithDelimiter1() {
        int i = 0;
        char theDelimiter = Delimiter.DOS_PATH.getChar();
        String testCase = TEST_CASE.replace(Delimiter.PATH.getChar(), theDelimiter);
        for (PatternMatchCase eCase : TEST_CASES) {
            if (IS_LOG_TESTS) {
                System.out.println("[" + i + "] " + eCase.isMatch() + ": Testing <" + testCase + "> against <" + eCase.getPattern(theDelimiter) + "> to be <" + eCase.isMatch() + "> ...");
            }
            PathMatcherImpl eMatcher = new PathMatcherImpl(eCase.getPattern(theDelimiter), theDelimiter);
            String[] theResult = eMatcher.toWildcardReplacements(testCase);
            if (IS_LOG_TESTS) {
                System.out.println("[" + i + "] " + eCase.isMatch() + ": Diff between <" + TEST_CASE + "> and <" + eCase.getPattern() + "> for " + this.toVerbose(eCase.getWildcardNames()) + " is := " + this.toVerbose(theResult));
            }
            Assertions.assertEquals((Object)eCase.isMatch(), (Object)eMatcher.isMatching(testCase));
            ++i;
        }
    }

    @Test
    public void testPathMatcherWithDelimiter2() {
        int i = 0;
        char theDelimiter = 'X';
        String testCase = TEST_CASE.replace(Delimiter.PATH.getChar(), theDelimiter);
        for (PatternMatchCase eCase : TEST_CASES) {
            if (IS_LOG_TESTS) {
                System.out.println("[" + i + "] " + eCase.isMatch() + ": Testing <" + testCase + "> against <" + eCase.getPattern(theDelimiter) + "> to be <" + eCase.isMatch() + "> ...");
            }
            PathMatcherImpl eMatcher = new PathMatcherImpl(eCase.getPattern(theDelimiter), theDelimiter);
            String[] theResult = eMatcher.toWildcardReplacements(testCase);
            if (IS_LOG_TESTS) {
                System.out.println("[" + i + "] " + eCase.isMatch() + ": Diff between <" + TEST_CASE + "> and <" + eCase.getPattern() + "> for " + this.toVerbose(eCase.getWildcardNames()) + " is := " + this.toVerbose(theResult));
            }
            Assertions.assertEquals((Object)eCase.isMatch(), (Object)eMatcher.isMatching(testCase));
            ++i;
        }
    }

    @Test
    public void testPathMatcherWithDelimiter3() {
        int i = 0;
        char theDelimiter = ':';
        String testCase = TEST_CASE.replace(Delimiter.PATH.getChar(), theDelimiter);
        for (PatternMatchCase eCase : TEST_CASES) {
            if (IS_LOG_TESTS) {
                System.out.println("[" + i + "] " + eCase.isMatch() + ": Testing <" + testCase + "> against <" + eCase.getPattern(theDelimiter) + "> to be <" + eCase.isMatch() + "> ...");
            }
            PathMatcherImpl eMatcher = new PathMatcherImpl(eCase.getPattern(theDelimiter), theDelimiter);
            String[] theResult = eMatcher.toWildcardReplacements(testCase);
            if (IS_LOG_TESTS) {
                System.out.println("[" + i + "] " + eCase.isMatch() + ": Diff between <" + TEST_CASE + "> and <" + eCase.getPattern() + "> for " + this.toVerbose(eCase.getWildcardNames()) + " is := " + this.toVerbose(theResult));
            }
            Assertions.assertEquals((Object)eCase.isMatch(), (Object)eMatcher.isMatching(testCase));
            ++i;
        }
    }

    @Test
    public void testWildcardSubstitutes() {
        int i = 0;
        for (PatternMatchCase eCase : TEST_CASES) {
            PathMatcherImpl eMatcher = new PathMatcherImpl(eCase.getPattern());
            String[] theResult = eMatcher.toWildcardReplacements(TEST_CASE);
            if (IS_LOG_TESTS) {
                System.out.println("[" + i + "] " + eCase.isMatch() + ": Diff between <" + TEST_CASE + "> and <" + eCase.getPattern() + "> for " + this.toVerbose(eCase.getWildcardNames()) + " is := " + this.toVerbose(theResult));
            }
            Assertions.assertEquals((Object)eCase.isMatch(), (Object)(theResult != null ? 1 : 0));
            ++i;
        }
    }

    @Test
    public void testWildcardNameSubstitutes() {
        int i = 0;
        for (PatternMatchCase eCase : TEST_CASES) {
            PathMatcherImpl eMatcher = new PathMatcherImpl(eCase.getPattern());
            String[] theResult = eMatcher.toWildcardReplacements(TEST_CASE, eCase.getWildcardNames());
            if (IS_LOG_TESTS) {
                System.out.println("[" + i + "] " + eCase.isMatch() + ": Diff between <" + TEST_CASE + "> and <" + eCase.getPattern() + "> for " + this.toVerbose(eCase.getWildcardNames()) + " is := " + this.toVerbose(theResult));
            }
            Assertions.assertEquals((Object)eCase.isMatch(), (Object)(theResult != null ? 1 : 0));
            ++i;
        }
    }

    @Test
    public void testEdgeCasesWildcardNames() {
        String thePathPattern = "/foo/${arg1}=*/${arg2}=*/bar";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        String[] theResult = theMatcher.toWildcardReplacements(TEST_CASE, new String[]{"arg1", "arg2"});
        Assertions.assertEquals((Object)"acme", (Object)theResult[0]);
        Assertions.assertEquals((Object)"atari", (Object)theResult[1]);
        if (IS_LOG_TESTS) {
            System.out.println(this.toVerbose(theResult));
        }
    }

    @Test
    public void testEdgeCasesSimpleNames() {
        String thePathPattern = "/foo/${arg1}/atari/bar";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        String[] theResult = theMatcher.toWildcardReplacements(TEST_CASE, new String[]{"arg1"});
        Assertions.assertEquals((Object)"acme", (Object)theResult[0]);
        if (IS_LOG_TESTS) {
            System.out.println(this.toVerbose(theResult));
        }
    }

    @Test
    public void testEdgeCase1() {
        String thePathPattern = "/**/$ref";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        boolean isMatching = theMatcher.isMatching("/foo/bar/hello/$ref");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertTrue((boolean)isMatching);
        isMatching = theMatcher.isMatching("/foo/bar/hello/?ref");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertFalse((boolean)isMatching);
    }

    @Test
    public void testEdgeCase2() {
        String thePathPattern = "/**/ref$";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        boolean isMatching = theMatcher.isMatching("/foo/bar/hello/ref$");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertTrue((boolean)isMatching);
        isMatching = theMatcher.isMatching("/foo/bar/hello/ref?");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertFalse((boolean)isMatching);
    }

    @Test
    public void testEdgeCase3() {
        String thePathPattern = "$/**/ref";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        boolean isMatching = theMatcher.isMatching("$/bar/hello/ref");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertTrue((boolean)isMatching);
        isMatching = theMatcher.isMatching("?/bar/hello/ref");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertFalse((boolean)isMatching);
    }

    @Test
    public void testEdgeCase4() {
        String thePathPattern = "{/**/ref";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        boolean isMatching = theMatcher.isMatching("{/bar/hello/ref");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertTrue((boolean)isMatching);
        isMatching = theMatcher.isMatching("?/bar/hello/ref");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertFalse((boolean)isMatching);
    }

    @Test
    public void testEdgeCase5() {
        String thePathPattern = "/**/ref{";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        boolean isMatching = theMatcher.isMatching("/bar/hello/ref{");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertTrue((boolean)isMatching);
        isMatching = theMatcher.isMatching("/bar/hello/ref?");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertFalse((boolean)isMatching);
    }

    @Test
    public void testEdgeCase6() {
        String thePathPattern = "/**/{ref";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        boolean isMatching = theMatcher.isMatching("/bar/hello/{ref");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertTrue((boolean)isMatching);
        isMatching = theMatcher.isMatching("/bar/hello/?ref");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertFalse((boolean)isMatching);
    }

    @Test
    public void testEdgeCase7() {
        String thePathPattern = "{$/**/{$ref}$";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        boolean isMatching = theMatcher.isMatching("{$/bar/hello/{$ref}$");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertTrue((boolean)isMatching);
        isMatching = theMatcher.isMatching("{$/bar/hello/{$ref}?");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertFalse((boolean)isMatching);
    }

    @Test
    public void testEdgeCase8() {
        String thePathPattern = "$/**/{$ref}$_{";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        boolean isMatching = theMatcher.isMatching("$/bar/hello/{$ref}$_{");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertTrue((boolean)isMatching);
        isMatching = theMatcher.isMatching("$/bar/hello/{$ref}?_{");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertFalse((boolean)isMatching);
    }

    @Test
    public void testEdgeCase9() {
        String thePathPattern = "$";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        boolean isMatching = theMatcher.isMatching("$");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertTrue((boolean)isMatching);
        isMatching = theMatcher.isMatching("?");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertFalse((boolean)isMatching);
    }

    @Test
    public void testEdgeCase10() {
        String thePathPattern = "{";
        PathMatcherImpl theMatcher = new PathMatcherImpl(thePathPattern);
        boolean isMatching = theMatcher.isMatching("{");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertTrue((boolean)isMatching);
        isMatching = theMatcher.isMatching("?");
        if (IS_LOG_TESTS) {
            System.out.println("Is matching = " + isMatching);
        }
        Assertions.assertFalse((boolean)isMatching);
    }

    private String toVerbose(String[] aStrings) {
        if (aStrings == null) {
            return "{}";
        }
        String theVerbose = "{ ";
        for (int l = 0; l < aStrings.length; ++l) {
            theVerbose = theVerbose + "\"" + aStrings[l] + "\"";
            if (l >= aStrings.length - 1) continue;
            theVerbose = theVerbose + ", ";
        }
        theVerbose = theVerbose + " }";
        return theVerbose;
    }

    private static class PatternMatchCase {
        private String _pattern;
        private boolean _isMatch;
        private String[] _wildcardNames;

        public PatternMatchCase(String aPattern, boolean isMatch, String[] aWildcardNames) {
            this._pattern = aPattern;
            this._isMatch = isMatch;
            this._wildcardNames = aWildcardNames;
        }

        public String getPattern() {
            return this._pattern;
        }

        public String getPattern(char aDelimiter) {
            return this._pattern.replace(Delimiter.PATH.getChar(), aDelimiter);
        }

        public boolean isMatch() {
            return this._isMatch;
        }

        public String[] getWildcardNames() {
            return this._wildcardNames;
        }
    }
}

