// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.matcher;

/**
 * A logical AND implementation of a {@link Matcher} encapsulating
 * {@link Matcher} instances. The AND {@link Matcher} matches when all of the
 * provided {@link Matcher} instances do match (AND).
 *
 * @param <M> The matchee type
 */
public class AndMatcherImpl<M> implements Matcher<M> {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private Matcher<M>[] _matchers;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTOR:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs an AND {@link Matcher}, i.e. all of the provided
	 * {@link Matcher} instances need to match in order for the AND
	 * {@link Matcher} to match.
	 * 
	 * @param aMatchers The {@link Matcher} instances to be combined with a
	 *        logical AND.
	 */
	@SafeVarargs
	public AndMatcherImpl( Matcher<M>... aMatchers ) {
		assert (aMatchers != null);
		for ( int i = 0; i < aMatchers.length; i++ ) {
			assert (aMatchers != null);
		}
		_matchers = aMatchers;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isMatching( M aMatchee ) {
		assert (aMatchee != null);
		for ( int i = 0; i < _matchers.length; i++ ) {
			if ( !_matchers[i].isMatching( aMatchee ) ) {
				return false;
			}
		}
		return true;
	}
}