// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.matcher;

/**
 * The matcher is used to test whether a matchee matches certain criteria. An
 * matcher may be an own implementation or it my get somehow 'nested' (inspired
 * by http://code.mycila.com/wiki/MycilaEvent) having different matchers which
 * in combination do some custom matching as needed by the business logic.
 * <p>
 * 
 * @param <M> The matchee type.
 *        <p>
 *        See http://code.mycila.com/wiki/MycilaEvent
 */
public interface Matcher<M extends Object> {

	/**
	 * Tests whether the given event is matching the mathcer's criteria.
	 * 
	 * @param aMatchee The matchee used for testing matchability.
	 * 
	 * @return True in case the matchee matches the matcher's criteria, else
	 *         false.
	 */
	boolean isMatching( M aMatchee );
}
