/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.matcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.refcodes.matcher.PathMatcher;
import org.refcodes.matcher.WildcardSubstitutes;
import org.refcodes.matcher.WildcardSubstitutesImpl;

public class PathMatcherImpl
implements PathMatcher {
    private static final String WILDCARD_NAME_PATTERN = "(?<=\\$\\{).*?(?=\\}\\=)";
    private static final int WILDCARD_NAME_PREFIX_LENGTH = 2;
    private static final int WILDCARD_NAME_SUFFIX_LENGTH = 2;
    private static final String SIMPLE_NAME_PATTERN = "(?<=\\$\\{).*?(?=\\})";
    private static final int SIMPLE_NAME_PREFIX_LENGTH = 2;
    private static final int SIMPLE_NAME_SUFFIX_LENGTH = 1;
    private static final String WILDCARD_ASTERISK = "([^\\/]*)";
    private static final String WILDCARD_DOUBOLE_ASTERISK = "(.*)";
    private static final String WILDCARD_QUESTION_MARK = "(\\\\w)";
    private static final String REGEX_SAFE_SLASH = "\\/";
    private static final String REGEX_SAFE_DOT = "\\.";
    private Pattern _matchee;
    private String _pathPattern = null;
    private String[] _wildcardNames = null;

    public PathMatcherImpl(String aPathPattern) {
        Object eTail;
        String eHead;
        String eName;
        assert (aPathPattern != null);
        this._pathPattern = aPathPattern;
        Object theRegex = aPathPattern;
        theRegex = aPathPattern.replaceAll("/", REGEX_SAFE_SLASH);
        theRegex = ((String)theRegex).replaceAll(REGEX_SAFE_DOT, REGEX_SAFE_DOT);
        theRegex = ((String)theRegex).replaceAll("(?<!\\*)\\*(?!\\*)", WILDCARD_ASTERISK);
        theRegex = ((String)theRegex).replaceAll("\\*\\*", WILDCARD_DOUBOLE_ASTERISK);
        theRegex = ((String)theRegex).replaceAll("\\?", WILDCARD_QUESTION_MARK);
        String theAsterisk = WILDCARD_ASTERISK.replaceAll("\\\\", "");
        String theDoubleAsterisk = WILDCARD_DOUBOLE_ASTERISK.replaceAll("(\\\\)\\\\", "$1");
        String theQuestionMark = WILDCARD_QUESTION_MARK.replaceAll("(\\\\)\\\\", "$1");
        ArrayList<String> theWildcardNames = new ArrayList<String>();
        Pattern theJokerPattern = Pattern.compile(WILDCARD_NAME_PATTERN);
        Matcher eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        while (eJokerMatcher.find()) {
            String eTruncated = ((String)theRegex).substring(eJokerMatcher.end() + 2);
            if (!(eTruncated.startsWith(theAsterisk) || eTruncated.startsWith(theDoubleAsterisk) || eTruncated.startsWith(theQuestionMark))) {
                throw new IllegalArgumentException("Your wildcard name (such as \"" + ((String)theRegex).substring(eJokerMatcher.start(), eJokerMatcher.start()) + "\") in pattern <" + aPathPattern + "> must prefix a wildcard such as \"" + theAsterisk + "\" or \"" + theDoubleAsterisk + "\" or \"" + theQuestionMark + "!");
            }
            eName = ((String)theRegex).substring(eJokerMatcher.start(), eJokerMatcher.end());
            theWildcardNames.add(eName);
            eHead = ((String)theRegex).substring(0, eJokerMatcher.start() - 2);
            eTail = ((String)theRegex).substring(eJokerMatcher.end() + 2);
            eTail = ((String)eTail).substring(0, 1) + "?<" + eName + ">" + ((String)eTail).substring(1);
            theRegex = eHead + (String)eTail;
            eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        }
        theJokerPattern = Pattern.compile(SIMPLE_NAME_PATTERN);
        eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        while (eJokerMatcher.find()) {
            eName = ((String)theRegex).substring(eJokerMatcher.start(), eJokerMatcher.end());
            theWildcardNames.add(eName);
            eHead = ((String)theRegex).substring(0, eJokerMatcher.start() - 2);
            eTail = WILDCARD_ASTERISK + ((String)theRegex).substring(eJokerMatcher.end() + 1);
            eTail = ((String)eTail).substring(0, 1) + "?<" + eName + ">" + ((String)eTail).substring(1);
            theRegex = eHead + (String)eTail;
            eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        }
        if (theWildcardNames.size() != 0) {
            this._wildcardNames = theWildcardNames.toArray(new String[theWildcardNames.size()]);
        }
        this._matchee = Pattern.compile((String)theRegex);
    }

    @Override
    public String[] getWildcardNames() {
        return this._wildcardNames;
    }

    @Override
    public String getPathPattern() {
        return this._pathPattern;
    }

    @Override
    public boolean isMatching(String aPath) {
        return this._matchee.matcher(aPath).matches();
    }

    @Override
    public WildcardSubstitutes toWildcardSubstitutes(String aPath) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i = 0; i < theMatcher.groupCount(); ++i) {
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        String[] theWildcardReplacements = theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
        HashMap<String, String> theNamedWildcardSubstitutes = null;
        if (this._wildcardNames != null) {
            theNamedWildcardSubstitutes = new HashMap<String, String>();
            for (String eName : this._wildcardNames) {
                theNamedWildcardSubstitutes.put(eName, theMatcher.group(eName));
            }
        }
        return new WildcardSubstitutesImpl(theWildcardReplacements, theNamedWildcardSubstitutes);
    }

    @Override
    public String[] toWildcardReplacements(String aPath) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i = 0; i < theMatcher.groupCount(); ++i) {
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    @Override
    public String toWildcardReplacementAt(String aPath, int aIndex) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aIndex < theMatcher.groupCount()) {
            return theMatcher.group(aIndex + 1);
        }
        throw new IllegalArgumentException("Your provided index <" + aIndex + "> exceeds the number if wildcards <" + theMatcher.groupCount() + "> defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".");
    }

    @Override
    public String[] toWildcardReplacementsAt(String aPath, int ... aIndexes) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aIndexes == null || aIndexes.length == 0) {
            return new String[0];
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i : aIndexes) {
            if (i >= theMatcher.groupCount()) {
                throw new IllegalArgumentException("Your provided index <" + i + "> exceeds the number of wildcards <" + theMatcher.groupCount() + "> defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".");
            }
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    @Override
    public String toWildcardReplacement(String aPath, String aWildcardName) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        try {
            return theMatcher.group(aWildcardName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Your provided name <" + aWildcardName + "> is not defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".", e);
        }
    }

    @Override
    public String[] toWildcardReplacements(String aPath, String ... aWildcardNames) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aWildcardNames == null || aWildcardNames.length == 0) {
            return new String[0];
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (String eWildcardName : aWildcardNames) {
            try {
                theWildcardSubstitutes.add(theMatcher.group(eWildcardName));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Your provided name <" + eWildcardName + "> is not defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".", e);
            }
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    public String toPattern() {
        return this._matchee.pattern();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._matchee == null ? 0 : this._matchee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathMatcherImpl other = (PathMatcherImpl)obj;
        return !(this._matchee == null ? other._matchee != null : !this._matchee.equals(other._matchee));
    }
}

