/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.matcher;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.matcher.Matcher;
import org.refcodes.matcher.MatcherSugar;
import org.refcodes.matcher.PathMatcher;

public class MatcherExamples {
    private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testMatcherSchema() {
        Matcher theSportsMatcher = MatcherSugar.or((Matcher[])new Matcher[]{MatcherSugar.equalWith((Object)"Soccer"), MatcherSugar.equalWith((Object)"Football")});
        Matcher thePoliticsMatcher = MatcherSugar.or((Matcher[])new Matcher[]{MatcherSugar.equalWith((Object)"War"), MatcherSugar.equalWith((Object)"Education")});
        Matcher theMediaMatcher = MatcherSugar.or((Matcher[])new Matcher[]{MatcherSugar.equalWith((Object)"TV"), MatcherSugar.equalWith((Object)"Streaming")});
        Matcher theEntertainmentMatcher = MatcherSugar.or((Matcher[])new Matcher[]{theSportsMatcher, theMediaMatcher});
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theSportsMatcher.toSchema());
            System.out.println();
            System.out.println(thePoliticsMatcher.toSchema());
            System.out.println();
            System.out.println(theMediaMatcher.toSchema());
            System.out.println();
            System.out.println(theEntertainmentMatcher.toSchema());
            System.out.println();
        }
    }

    @Test
    public void testPaths1() {
        PathMatcher theMatcher = new PathMatcher("/*/acme/**");
        String thePath = "/foo/acme/atari/bar";
        System.out.println("\"" + thePath + "\" -?-> \"/*/acme/**\" --> " + theMatcher.isMatching((Object)thePath));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)thePath));
        thePath = "/bar/acme/commodore/bar";
        System.out.println("\"" + thePath + "\" -?-> \"/*/acme/**\" --> " + theMatcher.isMatching((Object)thePath));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)thePath));
        thePath = "/foo/evil/bad/bar";
        System.out.println("\"" + thePath + "\" -?-> \"/*/acme/**\" --> " + theMatcher.isMatching((Object)thePath));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)thePath));
    }

    @Test
    public void testPaths2() {
        PathMatcher theMatcher = new PathMatcher("/acme/**/${tail}");
        String thePath = "/acme/foo/atari";
        String theVar = theMatcher.toWildcardReplacement(thePath, "tail");
        System.out.println("\"" + thePath + "\" -?-> \"/acme/**/${tail}\" --> " + theVar);
        Assertions.assertEquals((Object)"atari", (Object)theVar);
        thePath = "/acme/foo/commodore";
        theVar = theMatcher.toWildcardReplacement(thePath, "tail");
        System.out.println("\"" + thePath + "\" -?-> \"/acme/**/${tail}\" --> " + theVar);
        Assertions.assertEquals((Object)"commodore", (Object)theVar);
        thePath = "/acme/foo/what/ever/path/sinclair";
        theVar = theMatcher.toWildcardReplacement(thePath, "tail");
        System.out.println("\"" + thePath + "\" -?-> \"/acme/**/${tail}\" --> " + theVar);
        Assertions.assertEquals((Object)"sinclair", (Object)theVar);
        thePath = "/foo/what/ever/path/ghost";
        theVar = theMatcher.toWildcardReplacement(thePath, "tail");
        System.out.println("\"" + thePath + "\" -?-> \"/acme/**/${tail}\" --> " + theVar);
        Assertions.assertNull((Object)theVar);
    }

    @Test
    public void testInsideRange1() throws Exception {
        Matcher theMatcher = MatcherSugar.and((Matcher[])new Matcher[]{MatcherSugar.greaterOrEqualThan((Comparable)Integer.valueOf(-10)), MatcherSugar.lessOrEqualThan((Comparable)Integer.valueOf(10))});
        int i = -12;
        while (i <= 12) {
            System.out.println("-10 \u2264 " + i + " \u2264 10 --> " + theMatcher.isMatching((Object)i));
            ++i;
        }
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)-11));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)-10));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)-9));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)0));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)9));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)10));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)11));
    }

    @Test
    public void testInsideRange2() throws Exception {
        Matcher theMatcher = MatcherSugar.and((Matcher[])new Matcher[]{MatcherSugar.greaterThan((Comparable)Integer.valueOf(-10)), MatcherSugar.lessThan((Comparable)Integer.valueOf(10))});
        int i = -12;
        while (i < 12) {
            System.out.println("-10 < " + i + " < 10 --> " + theMatcher.isMatching((Object)i));
            ++i;
        }
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)-11));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)-10));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)-9));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)0));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)9));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)10));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)11));
    }

    @Test
    public void testInsideRange3() throws Exception {
        Matcher theMatcher = MatcherSugar.or((Matcher[])new Matcher[]{MatcherSugar.and((Matcher[])new Matcher[]{MatcherSugar.greaterOrEqualThan((Comparable)Integer.valueOf(-10)), MatcherSugar.lessOrEqualThan((Comparable)Integer.valueOf(-5))}), MatcherSugar.and((Matcher[])new Matcher[]{MatcherSugar.greaterOrEqualThan((Comparable)Integer.valueOf(5)), MatcherSugar.lessOrEqualThan((Comparable)Integer.valueOf(10))})});
        int i = -12;
        while (i <= 12) {
            System.out.println("-12 \u2264 " + i + " \u2264 12 --> " + theMatcher.isMatching((Object)i));
            ++i;
        }
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)-11));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)-10));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)-5));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)-4));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)0));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)4));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)5));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)10));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)11));
        System.out.println(theMatcher.toSchema());
    }

    @Test
    public void testOutsideRange1() throws Exception {
        Matcher theMatcher = MatcherSugar.or((Matcher[])new Matcher[]{MatcherSugar.lessOrEqualThan((Comparable)Integer.valueOf(-10)), MatcherSugar.greaterOrEqualThan((Comparable)Integer.valueOf(10))});
        int i = -12;
        while (i <= 12) {
            System.out.println("-10 \u2270 " + i + " \u2270 10 --> " + theMatcher.isMatching((Object)i));
            ++i;
        }
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)-11));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)-10));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)-9));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)0));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)9));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)10));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)11));
    }

    @Test
    public void testOutsideRange2() throws Exception {
        Matcher theMatcher = MatcherSugar.or((Matcher[])new Matcher[]{MatcherSugar.lessThan((Comparable)Integer.valueOf(-10)), MatcherSugar.greaterThan((Comparable)Integer.valueOf(10))});
        int i = -12;
        while (i <= 12) {
            System.out.println("-10 \u226e " + i + " \u226e 10 --> " + theMatcher.isMatching((Object)i));
            ++i;
        }
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)-11));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)-10));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)-9));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)0));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)9));
        Assertions.assertFalse((boolean)theMatcher.isMatching((Object)10));
        Assertions.assertTrue((boolean)theMatcher.isMatching((Object)11));
    }
}

