/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.matcher;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.matcher.Matcher;
import org.refcodes.matcher.MatcherSugar;

public class MatcherTest {
    private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testIsType() throws Exception {
        Matcher theTypeMatcher = MatcherSugar.isAssignableFrom(Class1.class);
        Assertions.assertTrue((boolean)theTypeMatcher.isMatching((Object)new Class1()));
        Assertions.assertTrue((boolean)theTypeMatcher.isMatching((Object)new Class2()));
        Assertions.assertTrue((boolean)theTypeMatcher.isMatching((Object)new Class3()));
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theTypeMatcher.toSchema());
        }
    }

    @Test
    public void testEquals() throws Exception {
        Matcher theStringMatcher = MatcherSugar.equalWith((Object)"Test");
        Assertions.assertTrue((boolean)theStringMatcher.isMatching((Object)"Test"));
        Assertions.assertFalse((boolean)theStringMatcher.isMatching((Object)"Hallo"));
        Assertions.assertFalse((boolean)theStringMatcher.isMatching((Object)"Foo"));
        Matcher theNotMatcher = MatcherSugar.not((Matcher)theStringMatcher);
        Assertions.assertFalse((boolean)theNotMatcher.isMatching((Object)"Test"));
        Assertions.assertTrue((boolean)theNotMatcher.isMatching((Object)"Hallo"));
        Assertions.assertTrue((boolean)theNotMatcher.isMatching((Object)"Foo"));
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theStringMatcher.toSchema());
        }
    }

    private class Class1 {
        private Class1() {
        }
    }

    private class Class2
    extends Class1 {
        private Class2() {
        }
    }

    private class Class3
    extends Class2 {
        private Class3() {
        }
    }
}

