/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.matcher;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.matcher.RegExpMatcher;
import org.refcodes.mixin.WildcardSubstitutes;

public class RegExpMatcherTest {
    private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");
    private static String TEST_CASE = "/foo/acme/atari/bar";

    @Test
    public void testRegExpMatcher() {
        IS_LOG_TEST_ENABLED = true;
        RegExpMatcher theMatcher = new RegExpMatcher("/foo/(?<arg1>[^/]*)/atari/bar");
        boolean isMatching = theMatcher.isMatching(TEST_CASE);
        Assertions.assertTrue((boolean)isMatching);
        WildcardSubstitutes theSubstitutes = theMatcher.toWildcardSubstitutes(TEST_CASE);
        String[] theReplacements = theSubstitutes.getWildcardReplacements();
        if (IS_LOG_TEST_ENABLED) {
            String[] stringArray = theReplacements;
            int n = theReplacements.length;
            int n2 = 0;
            while (n2 < n) {
                String eReplacement = stringArray[n2];
                System.out.println("Replacement = " + eReplacement);
                ++n2;
            }
        }
        Assertions.assertEquals((int)theReplacements.length, (int)1);
        Assertions.assertEquals((Object)theReplacements[0], (Object)"acme");
        String theReplacement = theSubstitutes.getWildcardReplacement("arg1");
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theReplacement);
        }
        Assertions.assertEquals((Object)"acme", (Object)theReplacement);
    }
}

