// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.matcher;

import org.refcodes.mixin.Schema;

/**
 * The {@link AbstractMatcheeMatcher} is composed of multiple {@link Matcher}
 * instances queried upon match requests as of {@link #isMatching(Object)}.
 * 
 * @param <M> The matchee type
 */
public abstract class AbstractMatcheeMatcher<M> extends AbstractMatcher<M> {

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected M _matchee;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs an {@link AbstractMatcheeMatcher} with the given description
	 * and matchee.
	 * 
	 * @param aAlias The alias for the according {@link Matcher} implementation.
	 * @param aDescription The according matcher's description.
	 * @param aMatchee The matchee to be matched against.
	 */
	public AbstractMatcheeMatcher( String aAlias, String aDescription, M aMatchee ) {
		super( aAlias, aDescription );
		assert ( aMatchee != null );
		_matchee = aMatchee;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public MatcherSchema toSchema() {
		final MatcherSchema theSchema = super.toSchema();
		theSchema.put( Schema.VALUE, _matchee );
		return theSchema;
	}
}
