/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.mixin;

import java.util.UUID;
import org.refcodes.mixin.EventMetaData;

public class EventMetaDataImpl
implements EventMetaData {
    protected String _uid;
    protected String _alias;
    protected String _group;
    protected String _channel;
    protected Class<?> _publisherType;

    public EventMetaDataImpl() {
        this.initUid();
    }

    public EventMetaDataImpl(Class<?> aPublisherType) {
        this.initUid();
        this._publisherType = aPublisherType;
    }

    public EventMetaDataImpl(String aAlias, String aGroup, String aChannel) {
        this._alias = aAlias;
        this._group = aGroup;
        this._channel = aChannel;
        this.initUid();
    }

    public EventMetaDataImpl(String aAlias, String aGroup) {
        this._alias = aAlias;
        this._group = aGroup;
        this.initUid();
    }

    public EventMetaDataImpl(String aChannel) {
        this._channel = aChannel;
        this.initUid();
    }

    public EventMetaDataImpl(String aAlias, String aGroup, String aChannel, String aUid, Class<?> aPublisherType) {
        this._alias = aAlias;
        this._group = aGroup;
        this._channel = aChannel;
        this._uid = aUid;
        this._publisherType = aPublisherType;
    }

    public EventMetaDataImpl(String aChannel, Class<?> aPublisherType) {
        this._channel = aChannel;
        this._publisherType = aPublisherType;
    }

    public EventMetaDataImpl(EventMetaData aMetaData) {
        this._alias = aMetaData.getAlias();
        this._group = aMetaData.getGroup();
        this._channel = aMetaData.getChannel();
        this._uid = aMetaData.getUniversalId();
        this._publisherType = aMetaData.getPublisherType();
    }

    @Override
    public String getUniversalId() {
        return this._uid;
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public String getGroup() {
        return this._group;
    }

    @Override
    public String getChannel() {
        return this._channel;
    }

    @Override
    public Class<?> getPublisherType() {
        return this._publisherType;
    }

    public String toString() {
        return "EventMetaData [Universal-TID=" + this._uid + ", name=" + this._alias + ", group=" + this._group + ", channel=" + this._channel + ", publisherType=" + this._publisherType.getSimpleName() + "]";
    }

    protected void initUid() {
        this._uid = UUID.randomUUID().toString();
    }
}

