/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.refcodes.data.CharSet;
import org.refcodes.exception.HiddenException;
import org.refcodes.numerical.BaseConverterBuilder;
import org.refcodes.numerical.NumericalUtility;

public class BaseConverterBuilderImpl
implements BaseConverterBuilder {
    private static boolean IS_VERFIY_ENABLED = true;
    private static final int DECIMAL_NUMBER_BASE = 10;
    private static final int BYTES_PER_LONG = 8;
    private int _numberBase = 10;
    private String _numberBaseValue = null;
    private byte[] _numberData = null;
    private char[] _charSet = null;
    private Map<Character, Integer> _charToValueMap = new HashMap<Character, Integer>();

    public BaseConverterBuilderImpl() {
        this.setCharSet(CharSet.ARABIC_BASE64.getCharSet());
    }

    public char[] getCharSet() {
        return this._charSet;
    }

    public void setCharSet(char[] aCharSet) {
        this._charSet = aCharSet;
        this._charToValueMap.clear();
        for (int i = 0; i < aCharSet.length; ++i) {
            this._charToValueMap.put(Character.valueOf(aCharSet[i]), i);
        }
    }

    public BaseConverterBuilder withCharSet(char[] aCharSet) {
        this.setCharSet(aCharSet);
        return this;
    }

    @Override
    public void setNumberBase(int aNumberBase) {
        this._numberBase = aNumberBase;
    }

    @Override
    public int getNumberBase() {
        return this._numberBase;
    }

    @Override
    public String toNumberBaseValue(long aNumber) {
        return BaseConverterBuilderImpl.toNumberBaseValue(NumericalUtility.toBytes(aNumber), this._numberBase, this._charSet, VerifyMode.REGULAR_CALL);
    }

    @Override
    public long getNumber() {
        return NumericalUtility.toLong(this._numberData);
    }

    @Override
    public long toNumber(String aNumberBaseValue) throws IllegalArgumentException {
        return NumericalUtility.toLong(BaseConverterBuilderImpl.toNumberData(aNumberBaseValue, this._numberBase, this._charToValueMap, VerifyMode.REGULAR_CALL));
    }

    @Override
    public void setNumber(long aNumber) {
        this.setNumberData(NumericalUtility.toBytes(aNumber));
    }

    @Override
    public String getNumberBaseValue() {
        this._numberBaseValue = BaseConverterBuilderImpl.toNumberBaseValue(this._numberData, this._numberBase, this._charSet, VerifyMode.REGULAR_CALL);
        this._numberData = null;
        return this._numberBaseValue;
    }

    @Override
    public void setNumberBaseValue(String aNumberBaseValue) {
        this._numberBaseValue = aNumberBaseValue;
        this._numberData = this.toNumberData(aNumberBaseValue);
    }

    @Override
    public byte[] getNumberData() {
        this._numberData = BaseConverterBuilderImpl.toNumberData(this._numberBaseValue, this._numberBase, this._charToValueMap, VerifyMode.REGULAR_CALL);
        this._numberBaseValue = null;
        return this._numberData;
    }

    @Override
    public void setNumberData(byte[] aNumberData) {
        this._numberData = aNumberData;
        this._numberBaseValue = null;
    }

    @Override
    public String toNumberBaseValue(byte[] aNumberData) {
        return BaseConverterBuilderImpl.toNumberBaseValue(aNumberData, this._numberBase, this._charSet, VerifyMode.REGULAR_CALL);
    }

    @Override
    public byte[] toNumberData(String aNumberBaseValue) {
        return BaseConverterBuilderImpl.toNumberData(aNumberBaseValue, this._numberBase, this._charToValueMap, VerifyMode.REGULAR_CALL);
    }

    private static String toNumberBaseValue(byte[] aNumberData, int aNumberBase, char[] aCharSet, VerifyMode aVerifyMode) {
        StringBuilder theNumberBaseValue = new StringBuilder();
        for (int i = 0; i < aNumberData.length && i < aNumberData.length; i += 8) {
            long eWord = NumericalUtility.toLong(aNumberData, i);
            if (eWord == 0L) {
                theNumberBaseValue.insert(0, aCharSet[0]);
            }
            while (eWord != 0L) {
                int eMod = (int)Math.abs(eWord % (long)aNumberBase);
                theNumberBaseValue.insert(0, aCharSet[eMod]);
                eWord -= (long)eMod;
                eWord /= (long)aNumberBase;
            }
        }
        if (IS_VERFIY_ENABLED && aVerifyMode == VerifyMode.REGULAR_CALL && !Arrays.equals(aNumberData, BaseConverterBuilderImpl.toNumberData(theNumberBaseValue.toString(), aNumberBase, BaseConverterBuilderImpl.toCharMap(aCharSet), VerifyMode.VERIFY_CALL))) {
            throw new IllegalArgumentException("Unable to process number data <" + BaseConverterBuilderImpl.toVerboseString(aNumberData) + "> for number base <" + aNumberBase + ">. Please pull <https://bitbucket.org/refcodes/refcodes-numerical>, create a fix and a push request, thx beforehand!!!");
        }
        return theNumberBaseValue.toString();
    }

    private static byte[] toNumberData(String aNumberBaseValue, int aNumberBase, Map<Character, Integer> aCharToValueMap, VerifyMode aVerifyMode) {
        ByteArrayOutputStream theBytes = new ByteArrayOutputStream();
        long eMultiplier = 1L;
        long eNumber = 0L;
        boolean isWritten = false;
        for (int i = aNumberBaseValue.length() - 1; i >= 0; --i) {
            long eDigit;
            isWritten = false;
            Integer eValue = aCharToValueMap.get(Character.valueOf(aNumberBaseValue.charAt(i)));
            if (eValue == null || eValue >= aNumberBase) {
                throw new IllegalArgumentException("The digit <" + aNumberBaseValue.charAt(i) + "> at index <" + i + "> of the value <" + aNumberBaseValue + "> is not a valid digit for number base <" + aNumberBase + ">.");
            }
            try {
                eDigit = Math.multiplyExact((long)eValue.intValue(), eMultiplier);
            }
            catch (ArithmeticException e) {
                try {
                    theBytes.write(NumericalUtility.toBytes(eNumber));
                }
                catch (IOException ignore) {
                    throw new HiddenException((Throwable)ignore);
                }
                eDigit = eValue.intValue();
                eMultiplier = 1L;
                eNumber = 0L;
            }
            try {
                eNumber = Math.addExact(eNumber, eDigit);
            }
            catch (ArithmeticException e) {
                try {
                    theBytes.write(NumericalUtility.toBytes(eNumber));
                    theBytes.write(NumericalUtility.toBytes(eDigit / eMultiplier));
                }
                catch (IOException ignore) {
                    throw new HiddenException((Throwable)ignore);
                }
                eMultiplier = 1L;
                eNumber = 0L;
                continue;
            }
            try {
                eMultiplier = Math.multiplyExact((long)aNumberBase, eMultiplier);
                continue;
            }
            catch (ArithmeticException e) {
                try {
                    theBytes.write(NumericalUtility.toBytes(eNumber));
                    isWritten = true;
                }
                catch (IOException ignore) {
                    throw new HiddenException((Throwable)ignore);
                }
                eMultiplier = 1L;
                eNumber = 0L;
            }
        }
        if (!isWritten) {
            try {
                theBytes.write(NumericalUtility.toBytes(eNumber));
            }
            catch (IOException i) {
                // empty catch block
            }
        }
        byte[] theByteArray = theBytes.toByteArray();
        if (IS_VERFIY_ENABLED && aVerifyMode == VerifyMode.REGULAR_CALL && !aNumberBaseValue.equals(BaseConverterBuilderImpl.toNumberBaseValue(theByteArray, aNumberBase, BaseConverterBuilderImpl.toCharSet(aCharToValueMap), VerifyMode.VERIFY_CALL))) {
            throw new IllegalArgumentException("Unable to process number base value \"" + aNumberBaseValue + "\" for number base <" + aNumberBase + ">. Please pull <https://bitbucket.org/refcodes/refcodes-numerical>, create a fix and a push request, thx beforehand!!!");
        }
        return theByteArray;
    }

    private static Map<Character, Integer> toCharMap(char[] aCharSet) {
        HashMap<Character, Integer> theCharToValueMap = new HashMap<Character, Integer>();
        for (int i = 0; i < aCharSet.length; ++i) {
            theCharToValueMap.put(Character.valueOf(aCharSet[i]), i);
        }
        return theCharToValueMap;
    }

    private static char[] toCharSet(Map<Character, Integer> aCharToValueMap) {
        char[] theCharSet = new char[aCharToValueMap.size()];
        for (Character eChar : aCharToValueMap.keySet()) {
            theCharSet[aCharToValueMap.get((Object)eChar).intValue()] = eChar.charValue();
        }
        return theCharSet;
    }

    protected static String toVerboseString(byte[] aBytes) {
        StringBuffer theBuffer = new StringBuffer();
        theBuffer.append("{ ");
        for (int i = 0; i < aBytes.length; ++i) {
            theBuffer.append(aBytes[i]);
            if (i >= aBytes.length - 1) continue;
            theBuffer.append(", ");
        }
        theBuffer.append(" }");
        return theBuffer.toString();
    }

    private static enum VerifyMode {
        VERIFY_CALL,
        REGULAR_CALL;

    }
}

