/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.exception.BugException;
import org.refcodes.numerical.NumericalUtility;

public enum Endianess {
    LITTLE_ENDIAN,
    BIG_ENDIAN;


    public byte[] toBytes(long l, int n) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toBigEndianBytes(l, n);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toLittleEndianBytes(l, n);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public byte[] toBytes(long l) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toBigEndianBytes(l);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toLittleEndianBytes(l);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public byte[] toBytes(int n) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toBigEndianBytes(n);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toLittleEndianBytes(n);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public byte[] toBytes(short s) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toBigEndianBytes(s);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toLittleEndianBytes(s);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public byte[] toBytes(float f) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toBigEndianBytes(f);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toLittleEndianBytes(f);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public byte[] toBytes(double d) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toBigEndianBytes(d);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toLittleEndianBytes(d);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public byte[] toUnsignedBytes(long l, int n) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toUnsignedBigEndianBytes(l, n);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toUnsignedLittleEndianBytes(l, n);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public byte[] toUnsignedBytes(long l) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toUnsignedBigEndianBytes(l);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toUnsignedLittleEndianBytes(l);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public byte[] toUnsignedBytes(int n) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toUnsignedBigEndianBytes(n);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toUnsignedLittleEndianBytes(n);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public byte[] toUnsignedBytes(short s) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toUnsignedBigEndianBytes(s);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toUnsignedLittleEndianBytes(s);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public long toLong(byte[] byArray) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toLongFromBigEndianBytes(byArray);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toLongFromLittleEndianBytes(byArray);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public long toUnsignedLong(byte[] byArray) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toUnsignedLongFromBigEndianBytes(byArray);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toUnsignedLongFromLittleEndianBytes(byArray);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public int toInteger(byte[] byArray) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toIntFromBigEndianBytes(byArray);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toIntFromLittleEndianBytes(byArray);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public int toUnsignedInteger(byte[] byArray) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toUnsignedIntFromBigEndianBytes(byArray);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toUnsignedIntFromLittleEndianBytes(byArray);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public short toShort(byte[] byArray) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toShortFromBigEndianBytes(byArray);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toShortFromLittleEndianBytes(byArray);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public short toUnsignedShort(byte[] byArray) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toUnsignedShortFromBigEndianBytes(byArray);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toUnsignedShortFromLittleEndianBytes(byArray);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public float toFloat(byte[] byArray) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toFloatFromBigEndianBytes(byArray);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toFloatFromLittleEndianBytes(byArray);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }

    public double toDouble(byte[] byArray) {
        switch (this) {
            case BIG_ENDIAN: {
                return NumericalUtility.toDoubleFromBigEndianBytes(byArray);
            }
            case LITTLE_ENDIAN: {
                return NumericalUtility.toDoubleFromLittleEndianBytes(byArray);
            }
        }
        throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
    }
}

