// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.numerical;

import static org.junit.jupiter.api.Assertions.*;

import java.util.Random;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.data.CharSet;

/**
 * The Class NumberBaseBuilderTest.
 *
 * @author steiner
 */
public class NumberBaseBuilderTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	private static boolean IS_LOG_TESTS = Boolean.getBoolean( "log.tests" );
	private static char[] CHAR_SET = CharSet.ARABIC_BASE64.getCharSet();
	private static Random RND = new Random();

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Test to number base 10 value.
	 */
	@Test
	public void testToNumberBase10Value() {
		int theNumberBase = 10;
		int theNumber = 2009;
		String theExpextedValue = "" + theNumber;
		BaseConverterBuilder theNumberBaseBuilder = new BaseConverterBuilder().withNumberBase( theNumberBase );
		// To number base value:
		String theValue = theNumberBaseBuilder.toNumberBaseValue( theNumber );
		// System.out.println( "Converting number <" + theNumber + "> using number
		// base <" + theNumberBase + "> to <" + theValue + ">" );
		assertEquals( theExpextedValue, theValue );
		// Back to number:
		long theLoopbackNumber = theNumberBaseBuilder.toNumber( theValue );
		// System.out.println( "Converting number base value <" + theValue + "> using
		// number base <" + theNumberBase + "> to <" + theLoopbackNumber + ">"
		// );
		assertEquals( theNumber, theLoopbackNumber );
	}

	/**
	 * Test to number base 16 value.
	 */
	@Test
	public void testToNumberBase16Value() {
		int theNumberBase = 16;
		int theNumber = 65535;
		String theExpextedValue = "FFFF";
		BaseConverterBuilder theNumberBaseBuilder = new BaseConverterBuilder().withNumberBase( theNumberBase );
		// To number base value:
		String theValue = theNumberBaseBuilder.toNumberBaseValue( theNumber );
		// System.out.println( "Converting number <" + theNumber + "> using number
		// base <" + theNumberBase + "> to <" + theValue + ">" );
		assertEquals( theExpextedValue, theValue );
		// Back to number:
		long theLoopbackNumber = theNumberBaseBuilder.toNumber( theValue );
		// System.out.println( "Converting number base value <" + theValue + "> using
		// number base <" + theNumberBase + "> to <" + theLoopbackNumber + ">"
		// );
		assertEquals( theNumber, theLoopbackNumber );
	}

	/**
	 * Test convert number base.
	 */
	@Test
	public void testConvertNumberBase() {
		String theNumberBaseValue = "FFFF";
		int hex = 16;
		int dec = 10;
		BaseConverterBuilder theNumberBaseBuilder = new BaseConverterBuilder();
		theNumberBaseBuilder.withNumberBase( hex ).withNumberBaseValue( theNumberBaseValue );
		String theResult = theNumberBaseBuilder.withNumberBase( dec ).getNumberBaseValue();
		byte[] theNumber = theNumberBaseBuilder.withNumberBase( dec ).toNumberData( theResult );
		theResult = theNumberBaseBuilder.withNumberBase( hex ).toNumberBaseValue( theNumber );
		assertEquals( theNumberBaseValue, theResult );
	}

	/**
	 * Test bigger than long.
	 */
	@Test
	public void testBiggerThanLong() {
		int theNumberBase = 9;
		BaseConverterBuilder theNumberBaseBuilder = new BaseConverterBuilder().withNumberBase( theNumberBase );
		// Back to number:
		// String theNumberBaseValue =
		// "999999999999999999999999999999999999999999999999999999999999236459787259347592345673456734756734564357924526945629465924365236523462345865234892356489765238947682359476823945723458679999999";
		String theNumberBaseValue = "888888888888888888888888888888888888888888888888888888888888236458787258347582345673456734756734564357824526845628465824365236523462345865234882356488765238847682358476823845723458678888888";
		byte[] theNumberData = theNumberBaseBuilder.toNumberData( theNumberBaseValue );
		String theNumberBaseLoopbackValue = theNumberBaseBuilder.toNumberBaseValue( theNumberData );
		if ( IS_LOG_TESTS ) {
			System.out.println( "From <" + theNumberBaseValue + ">" );
			System.out.println( "To   <" + theNumberBaseLoopbackValue + ">" );
		}
		assertEquals( theNumberBaseValue, theNumberBaseLoopbackValue );
	}

	/**
	 * Another one at char 62:
	 * "<1010010100101010111011011010100100100100010100010111010100010001>" "<1
	 * 10010100101010111011011010100100100100010100010111010100010001>".
	 */
	@Test
	@Disabled("Edge case currently not supported")
	public void testEdgeCase() {
		int theNumberBase = 3;
		BaseConverterBuilder theNumberBaseBuilder = new BaseConverterBuilder();
		String eNumberBaseValue = "2022102010122202221121200201100222201011";
		byte[] eNumberData;
		String eLoopbackValue;
		theNumberBaseBuilder.setNumberBase( theNumberBase );
		eNumberData = theNumberBaseBuilder.toNumberData( eNumberBaseValue );
		eLoopbackValue = theNumberBaseBuilder.toNumberBaseValue( eNumberData );
		if ( IS_LOG_TESTS ) {
			System.out.println( "From: <" + eNumberBaseValue + ">" );
			System.out.println( "  To: <" + eLoopbackValue + ">" );
		}
		assertEquals( eNumberBaseValue, eLoopbackValue );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * To random.
	 *
	 * @param aNumberBase the number base
	 * @param aColumnWidth the column width
	 * 
	 * @return the string
	 */
	@SuppressWarnings("unused")
	private String toRandom( int aNumberBase, int aColumnWidth ) {
		char[] theRandom = new char[aColumnWidth];
		for ( int i = 0; i < aColumnWidth; i++ ) {
			theRandom[i] = CHAR_SET[RND.nextInt( aNumberBase )];
		}
		return new String( theRandom );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
