/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.refcodes.data.CharSet;
import org.refcodes.exception.HiddenException;
import org.refcodes.mixin.CharSetAccessor;
import org.refcodes.numerical.NumberBaseAccessor;
import org.refcodes.numerical.NumericalUtility;

public class BaseConverterBuilder
implements CharSetAccessor.CharSetProperty,
CharSetAccessor.CharSetBuilder<BaseConverterBuilder>,
NumberBaseAccessor.NumberBaseProperty,
NumberBaseAccessor.NumberBaseBuilder<BaseConverterBuilder> {
    private static boolean IS_VERFIY_ENABLED = true;
    private static final int DECIMAL_NUMBER_BASE = 10;
    private static final int BYTES_PER_LONG = 8;
    private int _numberBase = 10;
    private String _numberBaseValue = null;
    private byte[] _numberData = null;
    private char[] _charSet = null;
    private Map<Character, Integer> _charToValueMap = new HashMap<Character, Integer>();

    public BaseConverterBuilder() {
        this.setCharSet(CharSet.ARABIC_BASE64.getCharSet());
    }

    public char[] getCharSet() {
        return this._charSet;
    }

    public void setCharSet(char[] cArray) {
        this._charSet = cArray;
        this._charToValueMap.clear();
        for (int i = 0; i < cArray.length; ++i) {
            this._charToValueMap.put(Character.valueOf(cArray[i]), i);
        }
    }

    public BaseConverterBuilder withCharSet(char[] cArray) {
        this.setCharSet(cArray);
        return this;
    }

    @Override
    public void setNumberBase(int n) {
        this._numberBase = n;
    }

    @Override
    public int getNumberBase() {
        return this._numberBase;
    }

    public String toNumberBaseValue(long l) {
        return BaseConverterBuilder.asEncoded(NumericalUtility.toBytes(l), this._numberBase, this._charSet, VerifyMode.REGULAR_CALL);
    }

    public long getNumber() {
        return NumericalUtility.toLong(this._numberData);
    }

    public long toNumber(String string) throws IllegalArgumentException {
        return NumericalUtility.toLong(BaseConverterBuilder.asDecoded(string, this._numberBase, this._charToValueMap, VerifyMode.REGULAR_CALL));
    }

    public void setNumber(long l) {
        this.setNumberData(NumericalUtility.toBytes(l));
    }

    public String getNumberBaseValue() {
        this._numberBaseValue = BaseConverterBuilder.asEncoded(this._numberData, this._numberBase, this._charSet, VerifyMode.REGULAR_CALL);
        this._numberData = null;
        return this._numberBaseValue;
    }

    public void setNumberBaseValue(String string) {
        this._numberBaseValue = string;
        this._numberData = this.toNumberData(string);
    }

    public byte[] getNumberData() {
        this._numberData = BaseConverterBuilder.asDecoded(this._numberBaseValue, this._numberBase, this._charToValueMap, VerifyMode.REGULAR_CALL);
        this._numberBaseValue = null;
        return this._numberData;
    }

    public void setNumberData(byte[] byArray) {
        this._numberData = byArray;
        this._numberBaseValue = null;
    }

    public String toNumberBaseValue(byte[] byArray) {
        return BaseConverterBuilder.asEncoded(byArray, this._numberBase, this._charSet, VerifyMode.REGULAR_CALL);
    }

    public byte[] toNumberData(String string) {
        return BaseConverterBuilder.asDecoded(string, this._numberBase, this._charToValueMap, VerifyMode.REGULAR_CALL);
    }

    @Override
    public BaseConverterBuilder withNumberBase(int n) {
        this.setNumberBase(n);
        return this;
    }

    public BaseConverterBuilder withNumberBaseValue(String string) {
        this.setNumberBaseValue(string);
        return this;
    }

    public BaseConverterBuilder withNumberData(byte[] byArray) {
        this.setNumberData(byArray);
        return this;
    }

    public BaseConverterBuilder withNumber(long l) {
        this.setNumber(l);
        return this;
    }

    public static String asEncoded(byte[] byArray, int n, char ... cArray) {
        return BaseConverterBuilder.asEncoded(byArray, n, cArray, VerifyMode.REGULAR_CALL);
    }

    public static byte[] asDecoded(String string, int n, char ... cArray) {
        return BaseConverterBuilder.asDecoded(string, n, BaseConverterBuilder.asCharMap(cArray), VerifyMode.REGULAR_CALL);
    }

    private static String asEncoded(byte[] byArray, int n, char[] cArray, VerifyMode verifyMode) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length && i < byArray.length; i += 8) {
            long l = NumericalUtility.toLong(byArray, i);
            if (l == 0L) {
                stringBuilder.insert(0, cArray[0]);
            }
            while (l != 0L) {
                int n2 = (int)Math.abs(l % (long)n);
                stringBuilder.insert(0, cArray[n2]);
                l -= (long)n2;
                l /= (long)n;
            }
        }
        if (IS_VERFIY_ENABLED && verifyMode == VerifyMode.REGULAR_CALL && !Arrays.equals(byArray, BaseConverterBuilder.asDecoded(stringBuilder.toString(), n, BaseConverterBuilder.asCharMap(cArray), VerifyMode.VERIFY_CALL))) {
            throw new IllegalArgumentException("Unable to process number data <" + BaseConverterBuilder.asVerboseString(byArray) + "> for number base <" + n + ">. Please pull <https://bitbucket.org/refcodes/refcodes-numerical>, create a fix and a push request, thx beforehand!!!");
        }
        return stringBuilder.toString();
    }

    private static byte[] asDecoded(String string, int n, Map<Character, Integer> map, VerifyMode verifyMode) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long l = 1L;
        long l2 = 0L;
        boolean bl = false;
        for (int i = string.length() - 1; i >= 0; --i) {
            long l3;
            bl = false;
            Integer n2 = map.get(Character.valueOf(string.charAt(i)));
            if (n2 == null || n2 >= n) {
                throw new IllegalArgumentException("The digit <" + string.charAt(i) + "> at index <" + i + "> of the value <" + string + "> is not a valid digit for number base <" + n + ">.");
            }
            try {
                l3 = Math.multiplyExact((long)n2.intValue(), l);
            }
            catch (ArithmeticException arithmeticException) {
                try {
                    byteArrayOutputStream.write(NumericalUtility.toBytes(l2));
                }
                catch (IOException iOException) {
                    throw new HiddenException((Throwable)iOException);
                }
                l3 = n2.intValue();
                l = 1L;
                l2 = 0L;
            }
            try {
                l2 = Math.addExact(l2, l3);
            }
            catch (ArithmeticException arithmeticException) {
                try {
                    byteArrayOutputStream.write(NumericalUtility.toBytes(l2));
                    byteArrayOutputStream.write(NumericalUtility.toBytes(l3 / l));
                }
                catch (IOException iOException) {
                    throw new HiddenException((Throwable)iOException);
                }
                l = 1L;
                l2 = 0L;
                continue;
            }
            try {
                l = Math.multiplyExact((long)n, l);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                try {
                    byteArrayOutputStream.write(NumericalUtility.toBytes(l2));
                    bl = true;
                }
                catch (IOException iOException) {
                    throw new HiddenException((Throwable)iOException);
                }
                l = 1L;
                l2 = 0L;
            }
        }
        if (!bl) {
            try {
                byteArrayOutputStream.write(NumericalUtility.toBytes(l2));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (IS_VERFIY_ENABLED && verifyMode == VerifyMode.REGULAR_CALL && !string.equals(BaseConverterBuilder.asEncoded(byArray, n, BaseConverterBuilder.asCharSet(map), VerifyMode.VERIFY_CALL))) {
            throw new IllegalArgumentException("Unable to process number base value \"" + string + "\" for number base <" + n + ">. Please pull <https://bitbucket.org/refcodes/refcodes-numerical>, create a fix and a push request, thx beforehand!!!");
        }
        return byArray;
    }

    private static Map<Character, Integer> asCharMap(char[] cArray) {
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        for (int i = 0; i < cArray.length; ++i) {
            hashMap.put(Character.valueOf(cArray[i]), i);
        }
        return hashMap;
    }

    private static char[] asCharSet(Map<Character, Integer> map) {
        char[] cArray = new char[map.size()];
        for (Character c : map.keySet()) {
            cArray[map.get((Object)c).intValue()] = c.charValue();
        }
        return cArray;
    }

    protected static String asVerboseString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]);
            if (i >= byArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    private static enum VerifyMode {
        VERIFY_CALL,
        REGULAR_CALL;

    }
}

