/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Text;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.numerical.CrcSize;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.NumericalUtility;

public class CrcAlgorithmTest {
    private static boolean IS_TEST_LOG_ENABLED = Boolean.getBoolean("test.log");

    @Test
    public void testNoBitError() {
        String theValue1 = Text.ARECIBO_MESSAGE + "A";
        String theOtherValue1 = Text.ARECIBO_MESSAGE + "A";
        for (CrcAlgorithmConfig eCrcChecksum : CrcAlgorithmConfig.values()) {
            long eChecksum = eCrcChecksum.toCrcChecksum(theValue1.getBytes(StandardCharsets.UTF_8));
            long eOtherChecksum = eCrcChecksum.toCrcChecksum(theOtherValue1.getBytes(StandardCharsets.UTF_8));
            if (IS_TEST_LOG_ENABLED) {
                System.out.println(eCrcChecksum.getName() + ": " + Long.toHexString(eChecksum) + " -?-> " + Long.toHexString(eOtherChecksum));
            }
            Assertions.assertEquals((long)eChecksum, (long)eOtherChecksum);
            Assertions.assertTrue((Long.toHexString(eChecksum).length() <= eCrcChecksum.getCrcSize().getCrcWidth() * 2 ? 1 : 0) != 0);
            Assertions.assertTrue((Long.toHexString(eOtherChecksum).length() <= eCrcChecksum.getCrcSize().getCrcWidth() * 2 ? 1 : 0) != 0);
            byte[] eBytes = eCrcChecksum.toCrcBytes(theValue1.getBytes(StandardCharsets.UTF_8), Endianess.LITTLE);
            Assertions.assertEquals((long)eChecksum, (long)Endianess.LITTLE.toUnsignedLong(eBytes));
        }
    }

    @Test
    public void testOneBitError() {
        String theValue1 = Text.ARECIBO_MESSAGE + "D";
        String theOtherValue1 = Text.ARECIBO_MESSAGE + "E";
        for (CrcAlgorithmConfig eCrcChecksum : CrcAlgorithmConfig.values()) {
            long eChecksum = eCrcChecksum.toCrcChecksum(theValue1.getBytes(StandardCharsets.UTF_8));
            long eOtherChecksum = eCrcChecksum.toCrcChecksum(theOtherValue1.getBytes(StandardCharsets.UTF_8));
            if (IS_TEST_LOG_ENABLED) {
                System.out.println(eCrcChecksum.getName() + ": " + Long.toHexString(eChecksum) + " -?-> " + Long.toHexString(eOtherChecksum));
            }
            Assertions.assertNotEquals((long)eChecksum, (long)eOtherChecksum);
            Assertions.assertTrue((Long.toHexString(eChecksum).length() <= eCrcChecksum.getCrcSize().getCrcWidth() * 2 ? 1 : 0) != 0);
            Assertions.assertTrue((Long.toHexString(eOtherChecksum).length() <= eCrcChecksum.getCrcSize().getCrcWidth() * 2 ? 1 : 0) != 0);
            byte[] eBytes = eCrcChecksum.toCrcBytes(theValue1.getBytes(StandardCharsets.UTF_8), Endianess.LITTLE);
            Assertions.assertEquals((long)eChecksum, (long)Endianess.LITTLE.toUnsignedLong(eBytes));
        }
    }

    @Test
    public void testTwoBitError() {
        String theValue1 = Text.ARECIBO_MESSAGE + "C";
        String theOtherValue1 = Text.ARECIBO_MESSAGE + "F";
        for (CrcAlgorithmConfig eCrcChecksum : CrcAlgorithmConfig.values()) {
            long eChecksum = eCrcChecksum.toCrcChecksum(theValue1.getBytes(StandardCharsets.UTF_8));
            long eOtherChecksum = eCrcChecksum.toCrcChecksum(theOtherValue1.getBytes(StandardCharsets.UTF_8));
            if (IS_TEST_LOG_ENABLED) {
                System.out.println(eCrcChecksum.getName() + ": " + Long.toHexString(eChecksum) + " -?-> " + Long.toHexString(eOtherChecksum));
            }
            Assertions.assertNotEquals((long)eChecksum, (long)eOtherChecksum);
            Assertions.assertTrue((Long.toHexString(eChecksum).length() <= eCrcChecksum.getCrcSize().getCrcWidth() * 2 ? 1 : 0) != 0);
            Assertions.assertTrue((Long.toHexString(eOtherChecksum).length() <= eCrcChecksum.getCrcSize().getCrcWidth() * 2 ? 1 : 0) != 0);
            byte[] eBytes = eCrcChecksum.toCrcBytes(theValue1.getBytes(StandardCharsets.UTF_8), Endianess.LITTLE);
            Assertions.assertEquals((long)eChecksum, (long)Endianess.LITTLE.toUnsignedLong(eBytes));
        }
    }

    @Test
    public void testRandomLongChecksum() {
        for (CrcAlgorithmConfig eCrcChecksum : CrcAlgorithmConfig.values()) {
            for (int i = 0; i < 1024; ++i) {
                long eValue = (long)(Math.random() * 9.223372036854776E18);
                long eChecksum = eCrcChecksum.toCrcChecksum(NumericalUtility.toBytes((long)eValue));
                long eOtherChecksum = eCrcChecksum.toCrcChecksum(NumericalUtility.toBytes((long)eValue));
                if (IS_TEST_LOG_ENABLED) {
                    System.out.print(eCrcChecksum.getName() + ": " + eValue + " = " + Long.toHexString(eChecksum) + " -?-> " + Long.toHexString(eOtherChecksum));
                }
                Assertions.assertEquals((long)eChecksum, (long)eOtherChecksum);
                Assertions.assertTrue((Long.toHexString(eChecksum).length() <= eCrcChecksum.getCrcSize().getCrcWidth() * 2 ? 1 : 0) != 0);
                byte[] eBytes = eCrcChecksum.toCrcBytes(NumericalUtility.toBytes((long)eValue), Endianess.LITTLE);
                if (IS_TEST_LOG_ENABLED) {
                    System.out.println(" {" + NumericalUtility.toHexString((String)", ", (byte[])eBytes) + "}");
                }
                Assertions.assertEquals((long)eChecksum, (long)Endianess.LITTLE.toUnsignedLong(eBytes));
            }
        }
    }

    @Test
    public void testCrcCategories() {
        for (CrcSize eCrcCategory : CrcSize.values()) {
            for (CrcAlgorithmConfig eCrcAlgorithm : eCrcCategory.getCrcAlgorithms()) {
                if (IS_TEST_LOG_ENABLED) {
                    System.out.println(eCrcCategory + " <-- " + eCrcAlgorithm);
                }
                Assertions.assertTrue((boolean)eCrcAlgorithm.name().startsWith(eCrcCategory.name()));
            }
        }
    }

    @Test
    public void testCrcAlgorithms() {
        for (CrcAlgorithmConfig eCrcAlgorithm : CrcAlgorithmConfig.values()) {
            CrcSize theCrcCategory = eCrcAlgorithm.getCrcSize();
            if (IS_TEST_LOG_ENABLED) {
                System.out.println(eCrcAlgorithm + " --> " + theCrcCategory);
            }
            Assertions.assertTrue((boolean)eCrcAlgorithm.name().startsWith(theCrcCategory.name()));
        }
    }
}

