/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.numerical.BaseConverterBuilder;

public class NumberBaseBuilderTest {
    private static boolean IS_TEST_LOG_ENABLED = Boolean.getBoolean("test.log");

    @Test
    public void testToNumberBase10Value() {
        int theNumberBase = 10;
        int theNumber = 2009;
        String theExpextedValue = "" + theNumber;
        BaseConverterBuilder theNumberBaseBuilder = new BaseConverterBuilder().withNumberBase(theNumberBase);
        String theValue = theNumberBaseBuilder.toDigits((long)theNumber);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println("Converting number <" + theNumber + "> using number base <" + theNumberBase + "> to <" + theValue + ">");
        }
        Assertions.assertEquals((Object)theExpextedValue, (Object)theValue);
        long theLoopbackNumber = theNumberBaseBuilder.toNumber(theValue);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println("Converting number base value <" + theValue + "> using number base <" + theNumberBase + "> to <" + theLoopbackNumber + ">");
        }
        Assertions.assertEquals((long)theNumber, (long)theLoopbackNumber);
    }

    @Test
    public void testToNumberBase16Value() {
        int theNumberBase = 16;
        int theNumber = 65535;
        String theExpextedValue = "FFFF";
        BaseConverterBuilder theNumberBaseBuilder = new BaseConverterBuilder().withNumberBase(theNumberBase);
        String theValue = theNumberBaseBuilder.toDigits((long)theNumber);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println("Converting number <" + theNumber + "> using number base <" + theNumberBase + "> to <" + theValue + ">");
        }
        Assertions.assertEquals((Object)theExpextedValue, (Object)theValue);
        long theLoopbackNumber = theNumberBaseBuilder.toNumber(theValue);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println("Converting number base value <" + theValue + "> using number base <" + theNumberBase + "> to <" + theLoopbackNumber + ">");
        }
        Assertions.assertEquals((long)theNumber, (long)theLoopbackNumber);
    }
}

