/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import java.util.Arrays;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.numerical.NumericalUtility;

public class NumericalUtilityTest {
    private static boolean IS_TEST_LOG_ENABLED = Boolean.getBoolean("test.log");

    @Test
    public void testNumberBaseCOnversion() {
        String theFromDigits = "FF";
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theFromDigits);
        }
        String theToDigits = NumericalUtility.convertNumberBase((int)16, (String)theFromDigits, (int)2);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theToDigits);
        }
        long theValue = NumericalUtility.fromNumberBase((int)2, (String)theToDigits);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theValue);
        }
        Assertions.assertEquals((long)255L, (long)theValue);
        String theResult = NumericalUtility.toNumberBase((long)theValue, (int)16);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theResult);
        }
        Assertions.assertEquals((Object)theFromDigits, (Object)theResult);
    }

    @Test
    public void testSetBits1() {
        byte theValue = 0;
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)0));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)1));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)2));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)3));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)4));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)5));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)6));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)7));
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)0, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)1, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)2, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)3, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)4, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)5, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)6, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)7, (boolean)true);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theValue);
        }
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)0));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)1));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)2));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)3));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)4));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)5));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)6));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)7));
        Assertions.assertEquals((byte)-1, (byte)theValue);
    }

    @Test
    public void testSetBits2() {
        byte theValue = -1;
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)0));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)1));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)2));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)3));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)4));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)5));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)6));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)7));
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)0, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)1, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)2, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)3, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)4, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)5, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)6, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)7, (boolean)false);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theValue);
        }
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)0));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)1));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)2));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)3));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)4));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)5));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)6));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)7));
        Assertions.assertEquals((int)0, (int)theValue);
    }

    @Test
    public void testSetBits3() {
        byte theValue = -1;
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)0));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)1));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)2));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)3));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)4));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)5));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)6));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)7));
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)0, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)1, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)2, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)3, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)4, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)5, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)6, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)7, (boolean)false);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theValue);
        }
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)0));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)1));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)2));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)3));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)4));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)5));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)6));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)7));
        Assertions.assertEquals((int)85, (int)theValue);
    }

    @Test
    public void testSetBits4() {
        byte theValue = 0;
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)0));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)1));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)2));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)3));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)4));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)5));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)6));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)7));
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)0, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)1, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)2, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)3, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)4, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)5, (boolean)false);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)6, (boolean)true);
        theValue = NumericalUtility.setBitAt((byte)theValue, (int)7, (boolean)false);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theValue);
        }
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)0));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)1));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)2));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)3));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)4));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)5));
        Assertions.assertTrue((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)6));
        Assertions.assertFalse((boolean)NumericalUtility.isBitSetAt((long)theValue, (int)7));
        Assertions.assertEquals((int)85, (int)theValue);
    }

    @Test
    public void testToBytes1() {
        byte[] theBytes = new byte[]{0, 1, 2, 3, 127, -128, -127, -3, -2, -1};
        if (IS_TEST_LOG_ENABLED) {
            System.out.println("[\u2713] " + Arrays.toString(theBytes));
        }
        String[] theStrings = new String[]{"{ 0x00 0x01 0x02 0x03 0x7F 0x80 0x81 0xFD 0xFE 0xFF }", "[   0,   1,   2,   3, 127, 128, 129, 253, 254, 255 ]", "[   0,   1,   2,   3, 127, 128, 129, -3, -2, -1 ]", "( 0    0x01,   2,0x03, 127,0x80, 129 0xFD, 254,0xFF )", "0,0x01,2,0x03,127,0x80,129,0xFD,254,0xFF"};
        for (int i = 0; i < theStrings.length; ++i) {
            String eString = theStrings[i];
            byte[] eBytes = NumericalUtility.toBytes((String)eString);
            if (IS_TEST_LOG_ENABLED) {
                System.out.println("[" + i + "] " + Arrays.toString(eBytes));
            }
            Assertions.assertArrayEquals((byte[])theBytes, (byte[])eBytes);
        }
    }

    @Test
    public void testToBytes2() {
        String[] theStrings = new String[]{"{ 0x00 0x01 0x02 0x03 0x7F 0x80 0x81 0xFD 0xFE 0x100 }", "[   0,   1,   X,   3, 127, 128, 129, 253, 254, 255 ]", "[   0,   1,   2,   3, 127, 128, 129, -3, -2, -129 ]", "( !0    0x01,   2,0x03, 127,0x80, 129 0xFD, 254,0xFF )", "0,0x01,2,0x03,127,0x80,129,0xFD,254,-256"};
        for (int i = 0; i < theStrings.length; ++i) {
            String eString = theStrings[i];
            try {
                byte[] eBytes = NumericalUtility.toBytes((String)eString);
                if (IS_TEST_LOG_ENABLED) {
                    System.out.println("[" + i + "] " + eString);
                    System.out.println("[x] " + Arrays.toString(eBytes));
                }
                Assertions.fail((String)"Expected an <IllegalArgumentException> (<NumberFormatException>!");
                continue;
            }
            catch (IllegalArgumentException expected) {
                if (!IS_TEST_LOG_ENABLED) continue;
                System.out.println("[" + i + "] " + expected.getMessage());
            }
        }
    }

    @Test
    public void testEdgeCase() {
        long theEdgeCase = -29216381152229859L;
        byte[] theBytes = NumericalUtility.toUnsignedBigEndianBytes((long)theEdgeCase, (int)8);
        long theConversion = NumericalUtility.toLongFromBigEndianBytes((byte[])theBytes);
        System.out.println("   theEdgeCase = " + theEdgeCase);
        System.out.println("theEdgeCaseHex = " + Long.toHexString(theEdgeCase));
        System.out.println("      theBytes = " + NumericalUtility.toHexString((byte[])theBytes));
        System.out.println(" theConversion = " + Long.toHexString(theConversion));
    }

    @Test
    public void testToLittleEndian() {
        byte[] theLittleEndian = new byte[]{(byte)Integer.parseInt("10010111", 2), (byte)Integer.parseInt("01000000", 2)};
        byte[] theResult = NumericalUtility.toLittleEndianBytes((long)16535L, (int)2);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println("Expected = " + Arrays.toString(theLittleEndian));
            System.out.println("  Result = " + Arrays.toString(theResult));
        }
        Assertions.assertArrayEquals((byte[])theLittleEndian, (byte[])theResult);
    }

    @Test
    public void testToBigEndian() {
        byte[] theLittleEndian = new byte[]{(byte)Integer.parseInt("01000000", 2), (byte)Integer.parseInt("10010111", 2)};
        byte[] theResult = NumericalUtility.toBigEndianBytes((long)16535L, (int)2);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println("Expected = " + Arrays.toString(theLittleEndian));
            System.out.println("  Result = " + Arrays.toString(theResult));
        }
        Assertions.assertArrayEquals((byte[])theLittleEndian, (byte[])theResult);
    }

    @Test
    public void testToDouble() {
        double theMin = -1.0;
        double theMax = 0.0;
        for (int i = 0; i < 15000; ++i) {
            for (int j = 1; j < 30; ++j) {
                String eText = this.toRandomText(j);
                Double eDouble = NumericalUtility.toDouble((String)eText);
                if (IS_TEST_LOG_ENABLED) {
                    System.out.println(eDouble + " := " + eText);
                }
                Assertions.assertTrue((eDouble >= 0.0 ? 1 : 0) != 0);
                Assertions.assertTrue((eDouble <= 1.0 ? 1 : 0) != 0);
                if (theMin == -1.0 || theMin > eDouble) {
                    theMin = eDouble;
                }
                if (!(theMax < eDouble)) continue;
                theMax = eDouble;
            }
        }
        if (IS_TEST_LOG_ENABLED) {
            System.out.println("Min := " + theMin);
            System.out.println("Max := " + theMax);
        }
    }

    @Test
    public void testToDoubleMin() {
        byte[] theBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        String theText = new String(theBytes);
        double theDouble = NumericalUtility.toDouble((String)theText);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theDouble + " := " + theText);
        }
    }

    @Test
    public void testToDoubleMax() {
        byte[] theBytes = new byte[]{-1};
        String theText = new String(theBytes);
        double theDouble = NumericalUtility.toDouble((String)theText);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theDouble + " := " + theText);
        }
    }

    @Test
    public void testToDoubles1() {
        String eString = "";
        for (int l = 1; l < 100; ++l) {
            for (int i = 1; i < 100; ++i) {
                try {
                    NumericalUtility.toDoubles((String)eString, (int)i);
                    continue;
                }
                catch (Exception e) {
                    Assertions.fail((String)("Expecting not to fail at length <" + i + ">! Message = " + e.getMessage()));
                }
            }
            eString = this.toRandomText(l);
        }
    }

    @Test
    public void testToDoubles2() {
        double[] theDoubles = NumericalUtility.toDoubles((String)"Hallo Welt, Chais is here to stay!", (int)3);
        if (IS_TEST_LOG_ENABLED) {
            for (double eDouble : theDoubles) {
                System.out.println(eDouble);
            }
        }
    }

    @Test
    public void testToDoubles3() {
        double[] theDoubles = NumericalUtility.toDoubles((String)"08021972", (int)3);
        if (IS_TEST_LOG_ENABLED) {
            for (double eDouble : theDoubles) {
                System.out.println(eDouble);
            }
        }
    }

    @Test
    public void testLongToBytes() {
        long theLong = 1234567890L;
        byte[] theBytes = NumericalUtility.toBytes((long)theLong);
        long theResult = NumericalUtility.toLong((byte[])theBytes);
        Assertions.assertEquals((long)theLong, (long)theResult);
    }

    @Test
    public void testLongToBytesZero() {
        long theLong = 0L;
        byte[] theBytes = NumericalUtility.toBytes((long)theLong);
        long theResult = NumericalUtility.toLong((byte[])theBytes);
        Assertions.assertEquals((long)theLong, (long)theResult);
    }

    @Test
    public void testLongToBytesMin() {
        long theLong = Long.MIN_VALUE;
        byte[] theBytes = NumericalUtility.toBytes((long)theLong);
        long theResult = NumericalUtility.toLong((byte[])theBytes);
        Assertions.assertEquals((long)theLong, (long)theResult);
    }

    @Test
    public void testLongToBytesMax() {
        long theLong = Long.MAX_VALUE;
        byte[] theBytes = NumericalUtility.toBytes((long)theLong);
        long theResult = NumericalUtility.toLong((byte[])theBytes);
        Assertions.assertEquals((long)theLong, (long)theResult);
    }

    @Test
    public void testIntegerToBytes() {
        int theInteger = 1234567890;
        byte[] theBytes = NumericalUtility.toBytes((int)theInteger);
        int theResult = NumericalUtility.toInt((byte[])theBytes);
        Assertions.assertEquals((int)theInteger, (int)theResult);
    }

    @Test
    public void testIntegerToBytesZero() {
        int theInteger = 0;
        byte[] theBytes = NumericalUtility.toBytes((int)theInteger);
        int theResult = NumericalUtility.toInt((byte[])theBytes);
        Assertions.assertEquals((int)theInteger, (int)theResult);
    }

    @Test
    public void testIntegerToBytesMin() {
        int theInteger = Integer.MIN_VALUE;
        byte[] theBytes = NumericalUtility.toBytes((int)theInteger);
        int theResult = NumericalUtility.toInt((byte[])theBytes);
        Assertions.assertEquals((int)theInteger, (int)theResult);
    }

    @Test
    public void testIntegerToBytesMax() {
        int theInteger = Integer.MAX_VALUE;
        byte[] theBytes = NumericalUtility.toBytes((int)theInteger);
        int theResult = NumericalUtility.toInt((byte[])theBytes);
        Assertions.assertEquals((int)theInteger, (int)theResult);
    }

    @Test
    public void testToFromBigEndianBytes() {
        int eValue;
        byte[] eBytes;
        for (int i = -1024; i < 1024; ++i) {
            eBytes = NumericalUtility.toBigEndianBytes((long)i, (int)8);
            eValue = NumericalUtility.toIntFromBigEndianBytes((byte[])eBytes);
            if (IS_TEST_LOG_ENABLED) {
                System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + i + "-?->" + eValue);
            }
            Assertions.assertEquals((int)i, (int)eValue);
        }
        int theValue = Integer.MAX_VALUE;
        eBytes = NumericalUtility.toBigEndianBytes((long)theValue, (int)8);
        eValue = NumericalUtility.toIntFromBigEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((int)theValue, (int)eValue);
        theValue = Integer.MIN_VALUE;
        eBytes = NumericalUtility.toBigEndianBytes((long)theValue, (int)8);
        eValue = NumericalUtility.toIntFromBigEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((int)theValue, (int)eValue);
        long theLong = Long.MAX_VALUE;
        eBytes = NumericalUtility.toBigEndianBytes((long)theLong, (int)8);
        long eLong = NumericalUtility.toLongFromBigEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theLong + "-?->" + eLong);
        }
        Assertions.assertEquals((long)theLong, (long)eLong);
        theLong = Long.MIN_VALUE;
        eBytes = NumericalUtility.toBigEndianBytes((long)theLong, (int)8);
        eLong = NumericalUtility.toLongFromBigEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theLong + "-?->" + eLong);
        }
        Assertions.assertEquals((long)theLong, (long)eLong);
    }

    @Test
    public void testToFromLittleEndianBytes() {
        int eValue;
        byte[] eBytes;
        for (int i = -1024; i < 1024; ++i) {
            eBytes = NumericalUtility.toLittleEndianBytes((long)i, (int)8);
            eValue = NumericalUtility.toIntFromLittleEndianBytes((byte[])eBytes);
            if (IS_TEST_LOG_ENABLED) {
                System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + i + "-?->" + eValue);
            }
            Assertions.assertEquals((int)i, (int)eValue);
        }
        int theValue = Integer.MAX_VALUE;
        eBytes = NumericalUtility.toLittleEndianBytes((long)theValue, (int)8);
        eValue = NumericalUtility.toIntFromLittleEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((int)theValue, (int)eValue);
        theValue = Integer.MIN_VALUE;
        eBytes = NumericalUtility.toLittleEndianBytes((long)theValue, (int)8);
        eValue = NumericalUtility.toIntFromLittleEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((int)theValue, (int)eValue);
        long theLong = Long.MAX_VALUE;
        eBytes = NumericalUtility.toLittleEndianBytes((long)theLong, (int)8);
        long eLong = NumericalUtility.toLongFromLittleEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theLong + "-?->" + eLong);
        }
        Assertions.assertEquals((long)theLong, (long)eLong);
        theLong = Long.MIN_VALUE;
        eBytes = NumericalUtility.toLittleEndianBytes((long)theLong, (int)8);
        eLong = NumericalUtility.toLongFromLittleEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theLong + "-?->" + eLong);
        }
        Assertions.assertEquals((long)theLong, (long)eLong);
    }

    @Test
    public void testFloatToFromBigEndianBytes() {
        float eValue;
        byte[] eBytes;
        float i = 0.0f;
        while (i < 1024.0f) {
            eBytes = NumericalUtility.toBigEndianBytes((float)i);
            eValue = NumericalUtility.toFloatFromBigEndianBytes((byte[])eBytes);
            if (IS_TEST_LOG_ENABLED) {
                System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + i + "-?->" + eValue);
            }
            Assertions.assertEquals((float)i, (float)eValue);
            i = (float)((double)i + 1.3337);
        }
        float theValue = Float.MAX_VALUE;
        eBytes = NumericalUtility.toBigEndianBytes((float)theValue);
        eValue = NumericalUtility.toFloatFromBigEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((float)theValue, (float)eValue);
        theValue = Float.MIN_VALUE;
        eBytes = NumericalUtility.toBigEndianBytes((float)theValue);
        eValue = NumericalUtility.toFloatFromBigEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((float)theValue, (float)eValue);
    }

    @Test
    public void testFloatToFromLittleEndianBytes() {
        float eValue;
        byte[] eBytes;
        float i = 0.0f;
        while (i < 1024.0f) {
            eBytes = NumericalUtility.toLittleEndianBytes((float)i);
            eValue = NumericalUtility.toFloatFromLittleEndianBytes((byte[])eBytes);
            if (IS_TEST_LOG_ENABLED) {
                System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + i + "-?->" + eValue);
            }
            Assertions.assertEquals((float)i, (float)eValue);
            i = (float)((double)i + 1.3337);
        }
        float theValue = Float.MAX_VALUE;
        eBytes = NumericalUtility.toLittleEndianBytes((float)theValue);
        eValue = NumericalUtility.toFloatFromLittleEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((float)theValue, (float)eValue);
        theValue = Float.MIN_VALUE;
        eBytes = NumericalUtility.toLittleEndianBytes((float)theValue);
        eValue = NumericalUtility.toFloatFromLittleEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((float)theValue, (float)eValue);
    }

    @Test
    public void testDoubleToFromBigEndianBytes() {
        double eValue;
        byte[] eBytes;
        for (double i = 0.0; i < 1024.0; i += 1.3337) {
            eBytes = NumericalUtility.toBigEndianBytes((double)i);
            eValue = NumericalUtility.toDoubleFromBigEndianBytes((byte[])eBytes);
            if (IS_TEST_LOG_ENABLED) {
                System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + i + "-?->" + eValue);
            }
            Assertions.assertEquals((double)i, (double)eValue);
        }
        double theValue = Double.MAX_VALUE;
        eBytes = NumericalUtility.toBigEndianBytes((double)theValue);
        eValue = NumericalUtility.toDoubleFromBigEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((double)theValue, (double)eValue);
        theValue = Double.MIN_VALUE;
        eBytes = NumericalUtility.toBigEndianBytes((double)theValue);
        eValue = NumericalUtility.toDoubleFromBigEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((double)theValue, (double)eValue);
    }

    @Test
    public void testDoubleToFromLittleEndianBytes() {
        double eValue;
        byte[] eBytes;
        for (double i = 0.0; i < 1024.0; i += 1.3337) {
            eBytes = NumericalUtility.toLittleEndianBytes((double)i);
            eValue = NumericalUtility.toDoubleFromLittleEndianBytes((byte[])eBytes);
            if (IS_TEST_LOG_ENABLED) {
                System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + i + "-?->" + eValue);
            }
            Assertions.assertEquals((double)i, (double)eValue);
        }
        double theValue = Double.MAX_VALUE;
        eBytes = NumericalUtility.toLittleEndianBytes((double)theValue);
        eValue = NumericalUtility.toDoubleFromLittleEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((double)theValue, (double)eValue);
        theValue = Double.MIN_VALUE;
        eBytes = NumericalUtility.toLittleEndianBytes((double)theValue);
        eValue = NumericalUtility.toDoubleFromLittleEndianBytes((byte[])eBytes);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(NumericalUtility.toHexString((String)" ", (byte[])eBytes) + " = " + theValue + "-?->" + eValue);
        }
        Assertions.assertEquals((double)theValue, (double)eValue);
    }

    private String toRandomText(int aLength) {
        Object eText = UUID.randomUUID().toString();
        while (((String)eText).length() < aLength) {
            eText = (String)eText + UUID.randomUUID().toString();
        }
        return ((String)eText).substring(0, aLength);
    }
}

