// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.numerical;

/**
 * The {@link ChecksumValidationMode} specifies on how to handle provided CRC
 * checksums compared to calculated CRC checksums.
 */
public enum ChecksumValidationMode {

	/**
	 * Ignore any CRC checksum mismatches.
	 */
	IGNORE_BAD_CHECKSUM,

	/**
	 * Follow an exception path upon CRC checksum mismatches.
	 */
	ENFORCE_VALID_CHECKSUM

}
