// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.numerical;

/**
 * A {@link Invertible} provides methods to apply a bijective function on a
 * value as well as an inverse function (on the bijective function's return
 * vale).
 * 
 * @param <B> The type of the bijective function's result (being the inverse
 *        function's input type).
 * @param <I> The type of the inverse function's result (being the bijective
 *        function's input type).
 */
public interface Invertible<B, I> extends BijectiveFunction<B, I>, InverseFunction<I, B> {}