// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.observer;

import org.refcodes.matcher.MatcherSchema;

/**
 * Matches the given action with the action stored in an event's meta data
 * (ACTION EQUAL WITH).
 *
 * @param <E> The matchee type.
 */
public class ActionEqualWithEventMatcher<E extends GenericActionMetaDataEvent<?, ?, ?>> implements EventMatcher<E> {

	static final String ACTION = "ACTION";

	private Object _action;

	/**
	 * Instantiates a new action equal with matcher impl.
	 *
	 * @param <A> the generic type
	 * @param aAction the action
	 */
	public <A> ActionEqualWithEventMatcher( A aAction ) {
		_action = aAction;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isMatching( E aEvent ) {
		assert (aEvent != null);

		if ( _action != null ) {
			return (_action.equals( aEvent.getAction() ));
		}
		else if ( aEvent.getAction() == null ) {
			return true;
		}
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public MatcherSchema toSchema() {
		MatcherSchema theSchema = new MatcherSchema( getClass(), "Matches the given action with the action stored in an event's meta data (ACTION EQUAL WITH)." );
		theSchema.put( ACTION, _action );
		return theSchema;
	}
}