// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////
package org.refcodes.observer;

import org.refcodes.matcher.MatcherSchema;

/**
 * Matches the given alias with the alias stored in an event's meta data (ALIAS
 * EQUAL WITH).
 * 
 * @param <E> The matchee type.
 */
public class AliasEqualWithEventMatcher<E extends GenericMetaDataEvent<?, ?>> implements EventMatcher<E> {

	static final String ALIAS = "ALIAS";

	private String _alias;

	/**
	 * Instantiates a new alias equal with matcher impl.
	 *
	 * @param aAlias the alias
	 */
	public AliasEqualWithEventMatcher( String aAlias ) {
		_alias = aAlias;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isMatching( E aEvent ) {
		assert (aEvent != null);

		if ( _alias != null ) {
			return (_alias.equals( aEvent.getMetaData().getAlias() ));
		}
		else if ( aEvent.getMetaData().getAlias() == null ) {
			return true;
		}
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public MatcherSchema toSchema() {
		MatcherSchema theSchema = new MatcherSchema( getClass(), "Matches the given alias <" + _alias + "> with the alias stored in an event's meta data (ALIAS EQUAL WITH)." );
		theSchema.put( ALIAS, _alias );
		return theSchema;
	}
}