// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

import org.refcodes.matcher.Matcher;
import org.refcodes.mixin.EventMetaData;

/**
 * This interface typifies the {@link Matcher} interface for the usage with
 * {@link GenericActionEvent} instances. An {@link EventMatcher} most commonly
 * uses the {@link EventMetaData} (as defined with the
 * {@link GenericMetaDataEvent}) in order to determine whether an
 * {@link GenericActionEvent} matches {@link EventMetaData} properties or not.
 *
 * @param <E> The matchee type.
 */
public interface EventMatcher<E extends GenericEvent<?>> extends Matcher<E> {

	/**
	 * Tests whether the given {@link GenericActionEvent} is matching the
	 * {@link Matcher}'s criteria.
	 * 
	 * @param aEvent The {@link GenericActionEvent} used for testing its
	 *        matchability.
	 * 
	 * @return True in case the {@link GenericActionEvent} matches the
	 *         {@link Matcher}'s criteria, else false.
	 */
	@Override
	boolean isMatching( E aEvent );
}
