// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

/**
 * The {@link GenericActionPayloadEvent} represents an {@link ActionEvent} which
 * carries an additional payload.
 * 
 * @param <A> The type of the action stored in the event.
 * @param <P> The type of the payload to be carried.
 * @param <SRC> The type of the source in question.
 */
public interface GenericActionPayloadEvent<A, P, SRC> extends GenericPayloadEvent<P, SRC>, GenericActionEvent<A, SRC> {}
